/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import jfb.gmf.modulesystem.ModulesystemPackage;
import jfb.gmf.modulesystem.TestBench;
import jfb.gmf.modulesystem.diagram.edit.parts.TestBenchEditPart;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTestBench_ThreadHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGraphicalEditPart editPart;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection && (editPart = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement()) instanceof TestBenchEditPart) {
            Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
            if (!FortressEnv.isExistFile(FortressEnv.getUserBenchesSourcePath())) {
                MessageBox messageDialog = new MessageBox(shell, 1);
                messageDialog.setText("Error");
                messageDialog.setMessage("No user benchs files found ! Please, add/create bench file on customization menu.");
                messageDialog.open();
                return null;
            }
            TestBenchEditPart testbenchEditPart = (TestBenchEditPart)editPart;
            TestBench mod = (TestBench)testbenchEditPart.resolveSemanticElement();
            TransactionalEditingDomain domain = testbenchEditPart.getEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            String name = mod.getTestBench_Thread();
            if (name.isEmpty()) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("Select TestBench File");
                fileDialog.setFilterPath(FortressEnv.getUserBenchesSourcePath());
                String[] filterExt = new String[]{"*.h"};
                fileDialog.setFilterExtensions(filterExt);
                name = fileDialog.open();
                if (name != null) {
                    name = FortressEnv.extractFilenameWithoutExtension(name);
                    commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getTestBench_TestBench_Thread(), (Object)name));
                } else {
                    return null;
                }
            }
            String filepath = String.valueOf(FortressEnv.getUserBenchesSourcePath()) + name + ".h";
            try {
                FortressEnv.openTextEditor(filepath);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && !pref.getTextEditorPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

