/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.generation.ReplaceKeyword;
import fortress.xml.FortressPreferences;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewUserRZDescriptionFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FortressEnv.CreateDirectory(FortressEnv.getConstraintsPath());
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("New RZ Description File");
        fileDialog.setFilterPath(FortressEnv.getConstraintsPath());
        String[] filterExt = new String[]{"*.rrd"};
        fileDialog.setFilterExtensions(filterExt);
        String name = fileDialog.open();
        if (name != null) {
            if (FortressEnv.isExistFile(name)) {
                MessageBox messageDialog = new MessageBox(shell, 1);
                messageDialog.setText("Error");
                messageDialog.setMessage("The filename already exists !");
                messageDialog.open();
                return null;
            }
            if (!name.endsWith(".rrd")) {
                name = String.valueOf(name) + ".rrd";
            }
            String template_filename = FortressEnv.getTemplateUserRZDescriptionFile();
            String filename = name;
            ReplaceKeyword rk = new ReplaceKeyword(template_filename, filename);
            String buf = "<!-- @file    " + filename + " -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "<!-- @author  XXX -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "<!-- @version 1.0 -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "<!-- @date    " + FortressEnv.today() + " -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "<!-- @section DESCRIPTION -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "<!-- RZ Description File  -->" + FortressEnv.EOL;
            buf = String.valueOf(buf) + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            try {
                rk.Generate();
                FortressEnv.openTextEditor(filename);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && !pref.getTextEditorPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

