/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ChangeCurrentConfig;

import Modulesystem.diagram.commands.InputDialog;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jdom.JDOMException;

public class ChangeCurrentConfigHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final FortressPreferences pref = FortressEnv.getFortressPreferences();
            pref.loadFile();
            Display display = PlatformUI.createDisplay();
            Vector<String> v = pref.getConfigurations();
            InputDialog inputDiag = new InputDialog(display, "Change current config", "Select a config", v.toArray());
            String configFile = (String)inputDiag.open(pref.getActiveConfiguration());
            if (configFile != null) {
                pref.setActiveConfiguration(configFile);
                pref.saveFile();
                FortressConsole.loadLogFile(configFile);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(FortressEnv.getTitle(FortressEnv.getProjectPath().substring(0, FortressEnv.getProjectPath().length() - 1), pref.getActiveConfiguration()));
                        }
                        catch (JDOMException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR : " + ex.getMessage());
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && pref.hasActiveConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

