/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdom.JDOMException;

public class ApplicationParametersTab {
    JFrame WindowsParameters;
    JTabbedPane Tab;
    DefaultListModel<ConfigApplication> Model_Application_list = null;
    JList<ConfigApplication> Application_list = null;
    FortressPreferences pref = null;
    FortressConfiguration config = null;
    JButton ADD_Application = null;
    JButton Remove_Application = null;
    JButton Duplicate_Application = null;
    JLabel instName_label = null;
    JTextField instName = null;
    JCheckBox Active_app = null;
    JLabel Qos_factor_label = null;
    JFormattedTextField Qos_factor = null;
    JLabel Qos_factor_unit_label = null;
    JLabel Energy_factor_label = null;
    JFormattedTextField Energy_factor = null;
    JLabel Energy_factor_unit_label = null;
    int selectedAppIndex;

    public ApplicationParametersTab(JFrame Windows, JTabbedPane Tab, FortressPreferences pref, FortressConfiguration config) {
        this.WindowsParameters = Windows;
        this.Tab = Tab;
        this.pref = pref;
        this.config = config;
        this.Model_Application_list = new DefaultListModel();
        this.Application_list = new JList<ConfigApplication>(this.Model_Application_list);
        this.ADD_Application = new JButton("    Add    ");
        this.Remove_Application = new JButton("  Remove   ");
        this.Duplicate_Application = new JButton(" Duplicate ");
        this.instName_label = new JLabel("Instance Name : ");
        this.instName = new JTextField();
        this.Active_app = new JCheckBox("Active  ");
        this.Qos_factor_label = new JLabel("QoS : ");
        this.Qos_factor = new JFormattedTextField((Object)new Integer(0)){

            @Override
            public void commitEdit() throws ParseException {
                super.commitEdit();
                if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                    int val = (Integer)ApplicationParametersTab.this.Qos_factor.getValue();
                    if (val < 0) {
                        val = 0;
                    } else if (val > 100) {
                        val = 100;
                    }
                    ApplicationParametersTab.this.Qos_factor.setValue(new Integer(val));
                    ConfigApplication configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                    configApp.setQoS(val);
                    ApplicationParametersTab.this.Model_Application_list.set(ApplicationParametersTab.this.selectedAppIndex, configApp);
                }
            }
        };
        this.Qos_factor_unit_label = new JLabel(" %   ");
        this.Energy_factor_label = new JLabel("Energy Consumption : ");
        this.Energy_factor = new JFormattedTextField((Object)new Integer(0)){

            @Override
            public void commitEdit() throws ParseException {
                super.commitEdit();
                if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                    int val = (Integer)ApplicationParametersTab.this.Energy_factor.getValue();
                    if (val < 0) {
                        val = 0;
                    }
                    ApplicationParametersTab.this.Energy_factor.setValue(new Integer(val));
                    ConfigApplication configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                    configApp.setEnergyConsumptionLimit(val);
                    ApplicationParametersTab.this.Model_Application_list.set(ApplicationParametersTab.this.selectedAppIndex, configApp);
                }
            }
        };
        this.Energy_factor_unit_label = new JLabel(" mJ");
        this.Application_list.setCellRenderer(new AppListRenderer());
        this.instName.setPreferredSize(new Dimension(150, 20));
        this.instName.setToolTipText("Instance Name of the Application");
        this.instName_label.setToolTipText("Instance Name of the Application");
        this.Active_app.setToolTipText("Active the application");
        this.Active_app.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                    ConfigApplication configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                    configApp.setActive(ApplicationParametersTab.this.Active_app.isSelected());
                    ApplicationParametersTab.this.Model_Application_list.set(ApplicationParametersTab.this.selectedAppIndex, configApp);
                }
            }
        });
        this.Qos_factor.setPreferredSize(new Dimension(50, 20));
        this.Qos_factor.setToolTipText("Minimum QoS of the application");
        this.Qos_factor_label.setToolTipText("Minimum QoS of the application");
        this.Energy_factor.setPreferredSize(new Dimension(50, 20));
        this.Energy_factor.setToolTipText("Minimum Energy Consumption of the application");
        this.Energy_factor_label.setToolTipText("Minimum Energy Consumption of the application");
        this.selectedAppIndex = -1;
    }

    protected void loadConfigApplicationField(ConfigApplication ca) {
        this.instName.setText(ca.getInstanceName());
        this.Active_app.setSelected(ca.isActive());
        this.Qos_factor.setValue(ca.getQoS());
        this.Energy_factor.setValue(ca.getEnergyConsumptionLimit());
    }

    protected void saveConfigApplicationField(ConfigApplication ca) {
        ca.setInstanceName(this.instName.getText());
        ca.setActive(this.Active_app.isSelected());
        ca.setQoS((Integer)this.Qos_factor.getValue());
        ca.setEnergyConsumptionLimit((Integer)this.Energy_factor.getValue());
    }

    public void CreateApplicationParametersTab() {
        JPanel P_ApplicationParameters = new JPanel();
        JPanel p_Button = new JPanel();
        FlowLayout fl = new FlowLayout(2);
        fl.setHgap(10);
        p_Button.setLayout(fl);
        p_Button.add(this.ADD_Application);
        p_Button.add(this.Remove_Application);
        p_Button.add(this.Duplicate_Application);
        JLabel Application_list_Label = new JLabel("Application list:");
        JScrollPane Application_list_scroller = new JScrollPane(this.Application_list);
        Application_list_scroller.setPreferredSize(new Dimension(760, 300));
        JPanel p_Application_list = new JPanel();
        GroupLayout g_Application_list = new GroupLayout(p_Application_list);
        p_Application_list.setLayout(g_Application_list);
        g_Application_list.setHorizontalGroup(g_Application_list.createParallelGroup().addComponent(Application_list_Label).addComponent(Application_list_scroller));
        g_Application_list.setVerticalGroup(g_Application_list.createSequentialGroup().addComponent(Application_list_Label).addGap(10).addComponent(Application_list_scroller));
        JPanel p_Attribute_list = new JPanel();
        p_Attribute_list.setLayout(new FlowLayout(0));
        p_Attribute_list.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        p_Attribute_list.add(this.instName_label);
        p_Attribute_list.add(this.instName);
        p_Attribute_list.add(this.Active_app);
        p_Attribute_list.add(this.Qos_factor_label);
        p_Attribute_list.add(this.Qos_factor);
        p_Attribute_list.add(this.Qos_factor_unit_label);
        p_Attribute_list.add(this.Energy_factor_label);
        p_Attribute_list.add(this.Energy_factor);
        p_Attribute_list.add(this.Energy_factor_unit_label);
        P_ApplicationParameters.setLayout(new BorderLayout());
        P_ApplicationParameters.add((Component)p_Button, "First");
        P_ApplicationParameters.add((Component)p_Application_list, "Center");
        P_ApplicationParameters.add((Component)p_Attribute_list, "Last");
        JScrollPane ScrollPane_ApplicationParameters = new JScrollPane(P_ApplicationParameters);
        this.Tab.insertTab("Application Parameters", null, ScrollPane_ApplicationParameters, null, 3);
        this.Application_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (arg0.getValueIsAdjusting()) {
                    return;
                }
                if (ApplicationParametersTab.this.Model_Application_list.isEmpty()) {
                    ApplicationParametersTab.this.selectedAppIndex = -1;
                } else {
                    ConfigApplication configApp;
                    try {
                        if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                            configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                            String oldInstName = configApp.getInstanceName();
                            String newName = ApplicationParametersTab.this.instName.getText();
                            if (ApplicationParametersTab.this.config.existsConfigApplicationInstanceName(newName) && !oldInstName.equals(newName)) {
                                ApplicationParametersTab.this.instName.setText(oldInstName);
                                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                            }
                            ApplicationParametersTab.this.saveConfigApplicationField(configApp);
                            ApplicationParametersTab.this.config.updateConfigApplication(oldInstName, configApp);
                        }
                    }
                    catch (JDOMException e1) {
                        e1.printStackTrace();
                    }
                    ApplicationParametersTab.this.selectedAppIndex = ApplicationParametersTab.this.Application_list.getSelectedIndex();
                    if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                        configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                        ApplicationParametersTab.this.loadConfigApplicationField(configApp);
                    }
                }
            }
        });
        this.ADD_Application.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_application_file = new JFileChooser(FortressEnv.getProjectPath());
                chooser_application_file.setMultiSelectionEnabled(true);
                chooser_application_file.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".modulesystem") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return null;
                    }
                });
                chooser_application_file.setFileSelectionMode(0);
                int returnVal = chooser_application_file.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                            ConfigApplication configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                            String oldInstName = configApp.getInstanceName();
                            String newName = ApplicationParametersTab.this.instName.getText();
                            if (ApplicationParametersTab.this.config.existsConfigApplicationInstanceName(newName) && !oldInstName.equals(newName)) {
                                ApplicationParametersTab.this.instName.setText(oldInstName);
                                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                            }
                            ApplicationParametersTab.this.saveConfigApplicationField(configApp);
                            ApplicationParametersTab.this.config.updateConfigApplication(oldInstName, configApp);
                        }
                    }
                    catch (JDOMException e1) {
                        e1.printStackTrace();
                    }
                    ConfigApplication newApp = null;
                    File[] selectedFiles = chooser_application_file.getSelectedFiles();
                    int nbFile = selectedFiles.length;
                    int i = 0;
                    i = 0;
                    while (i < nbFile) {
                        try {
                            boolean localApp = (String.valueOf(selectedFiles[i].getParent()) + File.separator).equals(FortressEnv.getProjectPath());
                            String file = localApp ? selectedFiles[i].getName() : selectedFiles[i].getAbsolutePath();
                            newApp = new ConfigApplication(file, localApp, ConfigApplication.createInstanceName(ApplicationParametersTab.this.config.getConfigApplicationList(), "App_"));
                            ApplicationParametersTab.this.config.addConfigApplication(newApp);
                            ApplicationParametersTab.this.Model_Application_list.addElement(newApp);
                        }
                        catch (JDOMException e1) {
                            e1.printStackTrace();
                        }
                        ++i;
                    }
                    if (newApp != null) {
                        ApplicationParametersTab.this.Application_list.setSelectedValue(newApp, true);
                        ApplicationParametersTab.this.selectedAppIndex = ApplicationParametersTab.this.Application_list.getSelectedIndex();
                    }
                }
                if (ApplicationParametersTab.this.Application_list.getModel().getSize() == 0) {
                    ApplicationParametersTab.this.Remove_Application.setEnabled(false);
                } else {
                    ApplicationParametersTab.this.Remove_Application.setEnabled(true);
                }
            }
        });
        this.Remove_Application.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int currentIndex = ApplicationParametersTab.this.Application_list.getSelectedIndex();
                    ApplicationParametersTab.this.selectedAppIndex = -1;
                    ConfigApplication configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.Application_list.getSelectedIndex());
                    ApplicationParametersTab.this.config.removeConfigApplication(configApp);
                    ApplicationParametersTab.this.Model_Application_list.removeElementAt(ApplicationParametersTab.this.Application_list.getSelectedIndex());
                    if (!ApplicationParametersTab.this.Model_Application_list.isEmpty()) {
                        if (currentIndex < ApplicationParametersTab.this.Model_Application_list.size()) {
                            ApplicationParametersTab.this.Application_list.setSelectedIndex(currentIndex);
                        } else {
                            ApplicationParametersTab.this.Application_list.setSelectedIndex(ApplicationParametersTab.this.Model_Application_list.size() - 1);
                        }
                    }
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
                if (ApplicationParametersTab.this.Application_list.getModel().getSize() == 0) {
                    ApplicationParametersTab.this.Remove_Application.setEnabled(false);
                } else {
                    ApplicationParametersTab.this.Remove_Application.setEnabled(true);
                }
            }
        });
        this.Duplicate_Application.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ApplicationParametersTab.this.Application_list.getSelectedIndex() != -1) {
                    try {
                        ConfigApplication configApp;
                        if (ApplicationParametersTab.this.selectedAppIndex != -1) {
                            configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.selectedAppIndex);
                            String oldInstName = configApp.getInstanceName();
                            String newName = ApplicationParametersTab.this.instName.getText();
                            if (ApplicationParametersTab.this.config.existsConfigApplicationInstanceName(newName) && !oldInstName.equals(newName)) {
                                ApplicationParametersTab.this.instName.setText(oldInstName);
                                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                            }
                            ApplicationParametersTab.this.saveConfigApplicationField(configApp);
                            ApplicationParametersTab.this.config.updateConfigApplication(oldInstName, configApp);
                        }
                        configApp = ApplicationParametersTab.this.Model_Application_list.getElementAt(ApplicationParametersTab.this.Application_list.getSelectedIndex());
                        ConfigApplication newApp = new ConfigApplication(configApp, ConfigApplication.createInstanceName(ApplicationParametersTab.this.config.getConfigApplicationList(), "App_"));
                        ApplicationParametersTab.this.config.addConfigApplication(newApp);
                        ApplicationParametersTab.this.Model_Application_list.addElement(newApp);
                        ApplicationParametersTab.this.Application_list.setSelectedValue(newApp, true);
                        ApplicationParametersTab.this.selectedAppIndex = ApplicationParametersTab.this.Application_list.getSelectedIndex();
                    }
                    catch (JDOMException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void applyApplicatioParameters() throws JDOMException, IOException {
        if (this.selectedAppIndex != -1) {
            ConfigApplication configApp = this.Model_Application_list.getElementAt(this.selectedAppIndex);
            String oldInstName = configApp.getInstanceName();
            String newName = this.instName.getText();
            if (this.config.existsConfigApplicationInstanceName(newName) && !oldInstName.equals(newName)) {
                this.instName.setText(oldInstName);
                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
            }
            this.saveConfigApplicationField(configApp);
            this.config.updateConfigApplication(oldInstName, configApp);
        }
    }

    public void getApplicationParameter() {
        this.Model_Application_list.removeAllElements();
        try {
            this.setAplicationList(this.Model_Application_list);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        if (this.Application_list.getModel().getSize() == 0) {
            this.Remove_Application.setEnabled(false);
        } else {
            this.Remove_Application.setEnabled(true);
        }
    }

    public void setAplicationList(DefaultListModel<ConfigApplication> Model_Application_list) throws JDOMException {
        Vector<ConfigApplication> Report_list = this.config.getConfigApplicationList();
        Iterator i = Report_list.iterator();
        i = Report_list.iterator();
        if (Report_list != null) {
            while (i.hasNext()) {
                ConfigApplication x = (ConfigApplication)i.next();
                if (x == null) continue;
                Model_Application_list.addElement(x);
            }
        }
        if (!Model_Application_list.isEmpty()) {
            this.Application_list.setSelectedIndex(0);
            this.selectedAppIndex = 0;
            ConfigApplication ca = Model_Application_list.getElementAt(0);
            this.loadConfigApplicationField(ca);
        }
    }

    public boolean existApplicationInList(ConfigApplication App) {
        int j = 0;
        while (j < this.Model_Application_list.getSize()) {
            if (this.Model_Application_list.getElementAt(j).equals(App.toString())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public class AppListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ConfigApplication configApp = (ConfigApplication)value;
            if (configApp.isActive()) {
                label.setIcon(new ImageIcon(FortressEnv.getImageFile("enable-app.png")));
            } else {
                label.setIcon(new ImageIcon(FortressEnv.getImageFile("disable-app.png")));
            }
            String text = configApp.isLocal() ? String.valueOf(configApp.getInstanceName()) + "  [" + configApp.getFileName() + ", QoS = " + configApp.getQoS() + " %, Energy = " + configApp.getEnergyConsumptionLimit() + " mJ]" : String.valueOf(configApp.getInstanceName()) + "  [" + configApp.getFileName() + ", QoS = " + configApp.getQoS() + " %, Energy = " + configApp.getEnergyConsumptionLimit() + " mJ] " + configApp.getFile();
            label.setText(text);
            return label;
        }
    }
}

