/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    user_monitoring.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2013/06/10
 * @date    June 25, 2014 2:10:21 PM CEST
 * @section DESCRIPTION
 *
 *          Custom Monitoring
*/

#ifndef USER_MONITORING_H
#define USER_MONITORING_H

#include <systemc.h>
#include "monitoring.h"

/*
* NOTE:
*  Change the name of :
*  - user_monitoring_module_name : this is the monitoring module name declared in FoRTReSS preferences
*  - user_sig : example of a tracing variable 
*  - trace_update_thread : you can modify and add several threads
*
*  - Follow the steps below
*/


MONITORING_MODULE(user_monitoring_module_name) {  

	/***** STEP 1 *********************************************/
	/* Declaration                                            */
	/*                                                        */
	/* Types :                                                */
	/* double           : TRACE_VAR_DOUBLE                    */
	/* integer          : TRACE_VAR_INT                       */
	/* unsigned integer : TRACE_VAR_UINT                      */
	/* sc_bigint        : TRACE_VAR_SC_BIGINT                 */
	/* sc_bigint *      : TRACE_VAR_SC_BIGINT_PTR             */
	
	MONITORING_VAR_DOUBLE(user_sig);  

	
	/***** STEP 2 *********************************************/
	/* Init Variable(s) and Thread(s)                         */
	
	MONITORING_INIT(user_monitoring_module_name) {

		// Init Variable(s)
		// TRACE_VAR_SC_BIGINT_ALLOCATE(var_name, size, dim) (used TRACE_VAR_SC_BIGINT_PTR)
		user_sig = 0;

		// Init Thread(s) for Trace
		MONITORING_ADD_THREAD(user_monitoring_module_name, trace_update_thread);
	}

	/***** STEP 3 *********************************************/
	/* Record Variable(s)                                    */

	MONITORING_ACTIVATE {

		/*  2 Methods :
		*    - MONITORING_ANALOG_TRACE(declaration_name, "name_of_signal", min value, max value, height in pixel)
		*        height : in pixel, less than value 50 is not right. About 80 is a right value.
		*
		*    - MONITORING_TRACE(declaration_name, "name_of_signal", format) 
		*        format value: hexadecimal, ascii, unsigned, decimal
		*
		*  Note: The declaration order will be the wave declaration order in the trace file
		*/
		
		MONITORING_TRACE(user_sig, "NameOfSignalInTrace", 0, 100, 75);
	}

	/***** STEP 4 *********************************************/
	/* Define the Thread behavior(s)                          */

	MONITORING_THREAD(trace_update_thread) {

		// Get the scheduler interface
		Scheduler_interface& sched_if = services.getShedulerInterface();
	
		while(true) {

			/* Wait:
			*    - wait(100, SC_US) : Wait on time
			*    - wait(UPDATE_RZ_STATE_EVENT) : Wait on RZ state modification
			*    - wait(UPDATE_TASK_STATE_EVENT) : Wait on task state modification
			*    - wait(START_OF_SCHEDULING_EVENT) : Wait on start of scheduling event
			*    - wait(END_OF_SCHEDULING_EVENT) : Wait on end of scheduling event			
			*/  
			wait(100, SC_US);

			/* Modify Value of the Signal */
			user_sig = rand()%100;

		}
	}
	
};

#endif
