/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    window_function.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-04-10
 * @section DESCRIPTION
 *			Performs windowing on an anaglog trace
 */

#ifndef WINDOW_FUNCTION_H
#define WINDOW_FUNCTION_H

#include <list>
#include <systemc.h>

using namespace std;

class WindowFunction {
	
private:
	list<sc_time> occupationTimeOverSamplingPeriods;

	static sc_time WINDOW_FUNCTION_PERIOD;
	static sc_time ANALOG_TRACE_SAMPLING_PERIOD;

public:
	WindowFunction() {};

	void setNewValue(sc_time);
	double getInstantOccupationRate(void);

	static void setWindowFunctionPeriod(sc_time);
	static void setAnalogTraceSamplingPeriod(sc_time);
};

#endif
