/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    task_priority_comparator.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2011-04-01
 * @section DESCRIPTION
 *			Class used as a comparator for deadlines inside a manager interface.
 *			The class is implicitly used for the priority queue in order to 
 *			sort tasks.
 */

#ifndef TASK_PRIORITY_COMPARATOR_H
#define TASK_PRIORITY_COMPARATOR_H

#include "task_priority_comparator_interface.h"

/**
 * Earliest Deadline First (EDF) scheme
 */

BEGIN_PRIORITY_COMPARATOR(EDF) 
{
	return (lhs.get_deadline_time() > rhs.get_deadline_time());
}
END_PRIORITY_COMPARATOR


/**
 * Earliest Deadline First (EDF) scheme with priority management for tasks with same deadlines
 */

BEGIN_PRIORITY_COMPARATOR(EDF_WithPriorityArbiter) 
{
	if(lhs.get_deadline_time() == rhs.get_deadline_time()) {
		return (lhs.get_task_priority() > rhs.get_task_priority());
	} else {
		return (lhs.get_deadline_time() < rhs.get_deadline_time());
	}
}
END_PRIORITY_COMPARATOR


/**
 * First-In First-Out (FIFO) scheme
 */

BEGIN_PRIORITY_COMPARATOR(FIFO) 
{
	return false;
}
END_PRIORITY_COMPARATOR


#endif
