/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    scheduler_request.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date   2013-03-18
 * @section DESCRIPTION
 *			A scheduler request
 */

#ifndef SCHEDULER_REQUEST_H
#define SCHEDULER_REQUEST_H

#include "manager_interface.h"

/* Pass parameters  to Algo (preemption) */
class Algorithm_Parameters {

RZ* current_rz;
RZ_config& rz_config;

public:

	Algorithm_Parameters(RZ* _current_rz, RZ_config& _rz_config) : current_rz(_current_rz), rz_config(_rz_config) {
	}

	~Algorithm_Parameters() {
	}

	RZ& getCurrentRZ() {
		return *current_rz;
	}

	RZ_config& getRZConfig() {
		return rz_config;
	}

};

class SchedulerRequest : public Task_to_schedule_interface {

private:
	Manager_interface * taskToMap;
	int requestOwner;

public:
	SchedulerRequest(Manager_interface *task, int owner) : taskToMap(task), requestOwner(owner) {}

	int get_request_owner(void) const;

	// Task_priority_comparator_interface
	sc_time get_deadline_time(void) const;
	sc_time get_task_deadline(void) const;
	sc_time get_task_period(void) const;
	sc_time get_task_offset(void) const;
	int get_task_priority(void) const;
	sc_time get_new_period_start_time(void) const;
	void set_task_priority(int);

	// Task_to_schedule_interface
	bool has_implementation(TaskImplementation&) const;
	bool fits(RZ *rz);
	string getName(void) const;
	bool has_current_implementation(void);
	ModuleImplementation get_current_implementation(void);
	vector<int> getFollowingList(void) const;
	vector<int> getPrecedingList(void) const;
};

#endif
