/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconfiguration_unit.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-10-19
 * @section DESCRIPTION
 *			A reconfiguration unit, either HW or SW
 */

#ifndef RECONFIGURATION_UNIT_H
#define RECONFIGURATION_UNIT_H

#define SC_INCLUDE_DYNAMIC_PROCESSES

#include "window_function.h"
#include <systemc.h>
#include <list>

using namespace std;

class ReconfigurationUnit {

private:
	bool busy;
	sc_time busyTime;

	// Analog trace stuff
	sc_time requestTime;
	sc_time last_window_reset;
	sc_time busyTimeOnLastCall;

	WindowFunction window_function;

public:
	ReconfigurationUnit(void) {
		busy = false;
		busyTime = SC_ZERO_TIME;
		requestTime = SC_ZERO_TIME;
		last_window_reset = SC_ZERO_TIME;
	}

	bool isBusy(void);
	void setBusy(bool b);

	sc_time getBusyTime(void);
	sc_time getRequestTime(void);

	double getOccupationRateOverLastWindow(void);
};

#endif
