/**
 * UNS - CNRS
 * Copyright 2015 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    config_processor.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2015-04-02
 * @section DESCRIPTION
 *			Config Processor Name description
 */

#ifndef CONFIG_PROCESSOR_NAME_H
#define CONFIG_PROCESSOR_NAME_H

#include <string>
#include <set>
#include <map>

using namespace std;

class Config_processor_name  {
	
	string processor_name;
	
	float static_power_coeff;
	float idle_power_coeff;
	float run_power_coeff;

public:

	Config_processor_name(string processor_name_) {
		processor_name = processor_name_;
		static_power_coeff = 0;
		idle_power_coeff = 0;
		run_power_coeff = 0; 
	}
	
	Config_processor_name(string processor_name_, float static_power_coeff_, float idle_power_coeff_, float run_power_coeff_) {
		processor_name = processor_name_;
		static_power_coeff = static_power_coeff_;
		idle_power_coeff = idle_power_coeff_;
		run_power_coeff = run_power_coeff_; 
	}
	
	Config_processor_name(Config_processor_name& cfg) {
		processor_name = string(cfg.processor_name);
		static_power_coeff = cfg.static_power_coeff;
		idle_power_coeff = cfg.idle_power_coeff;
		run_power_coeff = cfg.run_power_coeff; 		
	}

	Config_processor_name(Config_processor_name* cfg) {
		processor_name = string(cfg->processor_name);
		static_power_coeff = cfg->static_power_coeff;
		idle_power_coeff = cfg->idle_power_coeff;
		run_power_coeff = cfg->run_power_coeff; 		
	}
	
	string toString() {
		return processor_name;
	}
		
	bool equals(Config_processor_name obj) {
		return obj.processor_name.compare(processor_name) == 0;
	}
	
	string getProcessorName() {
		return processor_name;
	}
	
	void setProcessor(string val) {
		processor_name = val;
	}
	
	void setStaticPowerCoeff(float val) {
		static_power_coeff = val;
	}	
	
	float getStaticPowerCoeff() {
		return static_power_coeff;
	}
	
	void setIdlePowerCoeff(float val) {
		idle_power_coeff = val;
	}	
	
	float getIdlePowerCoeff() {
		return idle_power_coeff;
	}
	
	void setRunPowerCoeff(float val) {
		run_power_coeff = val;
	}	
	
	float getRunPowerCoeff() {
		return run_power_coeff;
	}
};

#endif
