/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    user_algorithm_interface.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-07-01
 * @section DESCRIPTION
 *			Interface to be passed as a parameter for the user algorithm
 */

#ifndef APPLICATION_INTERFACE_H
#define APPLICATION_INTERFACE_H

#ifdef RECOSIM_PART
	#include <systemc.h>
#endif

using namespace std;


class Application_interface {
	
public:

	/**
	 * @brief Get the name of the application
	 * @return name (string)
	 */
	virtual string getName(void) = 0;

	/**
	 * @brief Check if the Application contains the task
	 * @param taskID Task id
	 * @return true if application contains the task
	 */
	virtual bool containsTask(int taskID) = 0;

	/**
	 * @brief Get the first task id of the application
	 * @return the task id
	 */
	virtual int getFirstTaskID() = 0;

	/**
	 * @brief Get the task number of the application
	 * @return number of tasks
	 */
	virtual int getTaskNumber() = 0;

};

#endif
