/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    algorithm_mode_command.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-03-15
 * @section DESCRIPTION
 *			Algorithm mode command
 */

#ifndef ALGORITHM_MODE_COMMAND_H
#define ALGORITHM_MODE_COMMAND_H

#include <systemc.h>
#include <string>

using namespace sc_core;
using namespace std;

class AlgorithmModeCommand {
	
private:

	string target_module;
	string command;
	sc_time delay;

public:

	AlgorithmModeCommand(string _target_module, string _command, sc_time _delay) : target_module(_target_module), command(_command), delay(_delay) {}

	string get_target_module(void) const;
	string get_command(void) const;
	sc_time get_delay(void) const;

};

class AlgorithmModeCommandComparison {
public:
	AlgorithmModeCommandComparison(){}

	bool operator() (const AlgorithmModeCommand& lhs, const AlgorithmModeCommand&rhs) const {
		return (lhs.get_delay() > rhs.get_delay());
	}
};


#endif
