/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    virtualHardwareTask.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-04-24
 * @section DESCRIPTION
 *			Representation of a virtual task, based on real tasks to build
 *			its resources requirements.
 */

#ifndef VIRTUAL_HARDWARE_TASK_H
#define VIRTUAL_HARDWARE_TASK_H

#include <iostream>
#include <map>
using namespace std;

#include "hardwareTask.h"

class VirtualHwTask : public HwTask {
	
private:
	map<RBType, int> resourceMap;
	Device *device;

public:
	/* Constructor */
	VirtualHwTask(string n, vector<HwTask*> tasks, Device *dev) {

		name = n;
		device = dev;

		// Infering resources from task vector
		for(int i = 0; i < (int) tasks.size(); i++) {
			map<RBType, int>::iterator it;
			map<RBType, int> res = tasks.at(i)->getResourceRequirementsPtr()->getPhysicalResources();
			for(it = res.begin(); it != res.end(); it++) {
				if(resourceMap[it->first] < it->second) resourceMap[it->first] = it->second;
			}
		}

		//info();

		resourceRequirements = ResourceRequirements(resourceMap, device);
	}

	~VirtualHwTask() {
		//if(resourceRequirements) delete resourceRequirements;
	}

	void info();

};

#endif
