/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    taskResourceFile.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-01-15
 * @section DESCRIPTION
 *			Class representing a synthesis report, used for task description
 */

#include "taskResourceFile.h"

#include <fstream>
#include <math.h>
#include <time.h>
#include "utils.h"

using namespace std;

double TaskResourceFile::STATIC_RESOURCES_MARGIN = 0;

//#define SYNTHESIS_REPORT_DEBUG

string TaskResourceFile::getName(void) {
	return name;
}

string TaskResourceFile::getDeviceID(void) {
	return deviceID;
}

DeviceClass TaskResourceFile::getDeviceClass(void) {
	return deviceClass;
}

Device* TaskResourceFile::getDevicePtr(void) {
	return device;
}

map<RBType, int> TaskResourceFile::getPhysicalResources(void) {
	return physicalResources;
}

map<RBType, int> TaskResourceFile::getStaticResources(void) {
	return staticResources;
}

void TaskResourceFile::setDeviceID(string dev) {
	//deviceID = dev;
	//device = new Device(dev);
	device = new Device();
	deviceID = device->getDeviceID();
	inferDeviceClass();
}

void TaskResourceFile::inferDeviceClass(void) {

	/*if(deviceID.find("xc5v") != string::npos) deviceClass = V5;
	else if(deviceID.find("xc6v") != string::npos) deviceClass = V6;
	else deviceClass = UNDEF;*/

	if(deviceID.substr(0, 1).compare("5") == 0) deviceClass = Virtex5;
	else if(deviceID.substr(0, 1).compare("6") == 0) deviceClass = Virtex6;
	else deviceClass = UNDEF;
}

void TaskResourceFile::info(void) {

	cout << endl << "Task requires:" << endl;
	for(map<RBType,int>::iterator it = physicalResources.begin(); it != physicalResources.end(); it++) {
		cout << "\t" << (*it).second << " " << device->getCellName(it->first) << " column(s)" << endl;
	}
}

void TaskResourceFile::setStaticResourcesMargin(double margin) {
	STATIC_RESOURCES_MARGIN = margin;
}

void TaskResourceFile::setResourcesMargin(double margin) {
	resourceMargin = margin;
}

double TaskResourceFile::getStaticResourceMargin(void) {
	return STATIC_RESOURCES_MARGIN;
}

void TaskResourceFile::convertResourceMap(map<RBType, int>& _map) {

	// Convert CLBs into Slice
	if(_map.find(CLBl) != _map.end()) {
		_map[Slice] += (2 * _map[CLBl]);
		_map.erase(CLBl);
	}

	if(_map.find(CLBm) != _map.end()) {
		_map[Slice] += _map[CLBm];
		_map[SliceM] += _map[CLBm];
		_map.erase(CLBm);
	}

}

void TaskResourceFile::convertAllResourceMaps(void) {
	convertResourceMap(physicalResources);
	convertResourceMap(staticResources);
}
