/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    task.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-10-10
 * @section DESCRIPTION
 *			Representation of a task
 */

#ifndef TASK_H
#define TASK_H

#include <string>
#include <set>
#include <vector>
using namespace std;

#include "taskInterface.h"

class Task {
	
protected:

	string name;							/*< Task name, including implementation name (Taskname.ImplementationName) */
	multiset<TaskInterface> taskInterfaces;	/*< Set of task interfaces, might be redundant */
	bool static_module;

public:
	/* Constructor */
	Task(string n, bool static_mod) : name(n), static_module(static_mod) {}
	Task(string n) : name(n), static_module(false) {}
	Task() {}

	Task(const Task &other) {
		name = other.name;
		taskInterfaces = other.taskInterfaces;
		static_module = other.static_module;
	}

	/* Getters */
	virtual string getName(void) const;
	virtual string getTaskName(void) const;
	virtual bool isStaticModule(void) const;

	/* Misc */
	virtual void addInterface(TaskInterface t, int n = 1);
	virtual bool hasInterface(string n);

};

#endif
