/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    RZStats.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-02-16
 * @section DESCRIPTION
 *			Statistics for an RZ as provided by the simulator.
 */

#ifndef RZSTATS_H
#define RZSTATS_H

#include <map>
#include <string>
#include <iostream>
using namespace std;

enum RZState {RZ_BLANK, RZ_RECONFIG, RZ_MAPPED, RZ_ACTIVE, RZ_RUNNING};	// /!\ Same as within RecoSim

class RZStats {

private:
	double rzStateTimes[5];
	map<string, double> taskExecutionTimes;
	bool isRZ;
	string name;

public:
	RZStats(string n, bool RZ, double blank, double reconfig, double mapped, double active, double running, map<string, double> execTimes) {
		isRZ = RZ;
		name = n;
		rzStateTimes[RZ_BLANK] = blank;
		rzStateTimes[RZ_RECONFIG] = reconfig;
		rzStateTimes[RZ_MAPPED] = mapped;
		rzStateTimes[RZ_ACTIVE] = active;
		rzStateTimes[RZ_RUNNING] = running;
		
		taskExecutionTimes = execTimes;
	}

	double getRZStateTime(RZState);
	void printRZStats(void);
	map<string, double> getTaskExecutionTimesMap(void);

};

#endif
