/**
 * @file	user_parameters.cpp
 * @author  XXX
 * @version 1.0
 * @date	XXX
 *
 * @section DESCRIPTION
 *
 * User defined parameters.
 */

#include "user_parameters.h"

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

#define MIDDLEWARE_GEN

//#if defined(RECOSIM_PART) || defined(MIDDLEWARE_PART)
//#ifdef MIDDLEWARE_PART
#ifndef FORTRESS_PART

/* Hierarchical Task Example */

const string HSEM_IN = "IN";
const string HSEM_OUT = "OUT";
const string CAMERA_TASK = "CAMERA_TASK";

const unsigned int APP_NUMBER = APPLICATION_NUMBER;
const string APP_PREFIX = "App";

map<const string, rs_event *> create_hierarchical_sem_map()
{
	map<const string, rs_event *> m;

	for (int i=0; i<APP_NUMBER; i++) {

        	stringstream ss;
        	ss << i;
        	string str = ss.str(); ss.str("");

		string app = APP_PREFIX +  str;
	
	#ifdef PARALLEL_BEHV
	
		for (int j=0; j<NB_CAMERA; j++) {
			ss.clear();       			
			ss << j;
        		str = ss.str(); ss.str("");

			m[app + "_1" + str + CAMERA_TASK + HSEM_IN] = new rs_event(0);
			m[app + "_1" + str + CAMERA_TASK + HSEM_OUT] = new rs_event(0);
		}
	#else
		m[app + CAMERA_TASK + HSEM_IN] = new rs_event(0);
		m[app + CAMERA_TASK + HSEM_OUT] = new rs_event(0);
	#endif
	}

	return m;
}

string extractApplicationName(string app_p) {
    if(app_p.find("_") != string::npos) {
        return (app_p.substr(0, app_p.find("_"))).c_str();
    }
    else return app_p;
}

map<const string, rs_event *> hierarchical_sem_map = create_hierarchical_sem_map();

/* End Hierarchical Task Example */


#endif

/**************************  END USER SPACE ********************************/
/***************************************************************************/
