/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit� de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    recosim_parameters.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2014/06/04
 * @date    April 15, 2016 9:05:29 AM CEST
 * @section DESCRIPTION
 *
 *          RecoSim parameters for xc7z020 device (Zynq7)
*/

#define FORTRESS_CONFIGURATION Config_Par


#include "reconfiguration_manager.h"
#include "user_parameters.h"

rs_time Reconfiguration_manager_base::MAXIMUM_SIMULATION_TIME = rs_time(7.0, RS_SEC);

rs_time Reconfiguration_manager_base::SCHEDULER_EXECUTION_TIME = rs_time(0, RS_US); 
double Reconfiguration_manager_base::SCHEDULER_ENERGY_CONSUMPTION = 0;
double Reconfiguration_manager_base::ENERGY_CONSUMPTION_LIMIT = 5000;
bool Reconfiguration_manager_base::GENERATE_ZERO_FILLED_LINE_IN_CSV = false; 
rs_time Reconfiguration_manager_base::TRACE_WINDOW_FUNCTION_LENGTH = rs_time(10000.0, RS_US);
bool Reconfiguration_manager_base::ALL_DEPENDENCIES_REQUIRED_BEFORE_REQUEST = false;

double Reconfiguration_manager_base::SCHEDULER_PERFORMANCE_EFFORT = 100;
double Reconfiguration_manager_base::SCHEDULER_POWER_EFFORT = 0;
double Reconfiguration_manager_base::SCHEDULER_AREA_EFFORT = 0;

int Reconfiguration_manager_base::NB_HW_RECONFIGURATION_UNITS = 1;
int Reconfiguration_manager_base::NB_SW_RECONFIGURATION_UNITS = 1;

