/**
  * @file    Camera_Out.h
  * @author  XXX
  * @version 1.0
  * @date    March 2, 2016 1:43:15 PM CET
  * @section DESCRIPTION
  * 
  * User IN Testbench algorithms files of Camera_Out
  */



#ifndef CAMERA_OUT_TESTBENCH_FILE_H
#define CAMERA_OUT_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/*******************/
/* Input TestBench */

template<int Ni>
void Camera_Out(Testbench_in_interface<Ni> &tb_interface) {
	
	/* Default Behavior */
	
	// Verify data 'on-the-fly'
	int nb_transactions_received = 0;
	int nb_diff = 0;
	int last_transaction_count[Ni];
	for(int i = 0; i < Ni; i++) last_transaction_count[i] = 0;

	while(nb_transactions_received != NB_TRANSACTIONS_TO_SEND*NB_CAMERA * Ni) {

		/* Time out right before end of simulation */
		rs_time timeout(Reconfiguration_manager::getMaximumSimulationTime() - rs_time_stamp() - rs_time(1, RS_US));	
		//wait(timeout, tb_interface.TB_IF_transaction_received_event());
		TB_IF_wait_all_responses_received_event_timeout(timeout);

		/* Hierarchical Task Example */
	#ifdef PARALLEL_BEHV
		string app_p = tb_interface.TB_IF_get_instance_top_application_name();
		rs_event  *sem = hierarchical_sem_map[app_p + CAMERA_TASK + HSEM_OUT];
		post_semaphore_ptr(sem);
	#else
		string app_p = extractApplicationName(tb_interface.TB_IF_get_instance_top_application_name());
		rs_event  *sem = hierarchical_sem_map[app_p + CAMERA_TASK + HSEM_OUT];
		post_semaphore_ptr(sem);
	#endif


		if(rs_time_stamp() == Reconfiguration_manager::getMaximumSimulationTime() - rs_time(1, RS_US)) {
			/* Reached end of simulation due to timeout, something is wrong with the testbench */
			cout << "CRITICAL WARNING: End of simulation reached but testbench thread is still waiting for transactions..." << endl;
			cout << "Testbench name: " << tb_interface.TB_IF_name();
			cout << "Consider revising:" << endl;
			cout << " - Testbench to wait for less transactions" << endl;
			cout << " - Module algorithms to send data more often" << endl;
			return;
		} 
		else {
			/* Event(s) received */
			for(int i = 0; i < Ni; i++) {
				if(tb_interface.TB_IF_get_nb_transactions_received_per_socket(i) != last_transaction_count[i]) {
					// Data received on this socket
					// Check data
					int *data_ptr = tb_interface.TB_IF_get_data_in_ptr(i);
					for(int j = 0; j < 16; j++) { 
						if(data_ptr[j] != ((last_transaction_count[i] << 16) | j)) {
							nb_diff++;
							//cout << "Socket " << i << ", Transaction " << last_transaction_count[i] << ", Data " << j << " -> " << hex << data_ptr[j] << " (expected " << ((last_transaction_count[i] << 16) | j) << ")" << endl;
						}
					}

					// Update transaction count
					last_transaction_count[i]++;

					break;
				}
			}

			nb_transactions_received++;
		}

		
	}

nb_diff = 0;

	if(nb_diff == 0) {
		tb_interface.get_logfile() << endl << "==================================================" << endl;
		tb_interface.get_logfile() << "  CONGRATULATIONS: Simulation ended successfully  " << endl;
		tb_interface.get_logfile() << "==================================================" << endl << endl;

		// Communicate with the simulation controller
		tb_interface.TB_IF_notify_simulation_controller(true);
	} else {
		tb_interface.get_logfile() << endl << "==================================================" << endl;
		tb_interface.get_logfile() << "         Simulation failed with " << dec << nb_diff << " errors            " << endl;
		tb_interface.get_logfile() << "==================================================" << endl << endl;

		exit(RECOSIM_TESTBENCH_CHECK_FAILED);
	}
}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
