#ifndef RS_TIME_H
#define RS_TIME_H

#include <sys/time.h>
#include <stdint.h>
#include <ostream>

enum rs_time_uint{RS_US=1,RS_MS=1000,RS_SEC=1000000};


class rs_time {
private :
  uint64_t m_value;
public :
  rs_time();
  ~rs_time();
  rs_time( const rs_time& t );
  rs_time( double   d);
  rs_time( double   d, rs_time_uint r);
  rs_time( uint64_t i);
  rs_time( uint64_t i, rs_time_uint r);
  rs_time( int      i);
  rs_time( int      i, rs_time_uint r);

  rs_time& operator = ( const rs_time& t );

  uint64_t value() const;  // relative to the time resolution

  double to_double() const;  // relative to the time resolution


  // relational operators

  bool operator == ( const rs_time& t ) const;
  bool operator != ( const rs_time& t ) const;
  bool operator < ( const rs_time& t ) const;
  bool operator <= ( const rs_time& t ) const;
  bool operator > ( const rs_time& t ) const;
  bool operator >= ( const rs_time& t ) const;


  // arithmetic operators

  rs_time& operator += ( const rs_time& t );
  rs_time& operator -= ( const rs_time& t );


  friend const rs_time operator + ( const rs_time& t1, const rs_time& t2 );
  friend const rs_time operator - ( const rs_time& t1, const rs_time& t2 );


    rs_time& operator *= ( double d );
    rs_time& operator /= ( double d );
  friend const rs_time operator * ( const rs_time& t, double d );
  friend const rs_time operator * ( double d, const rs_time& t );
  friend const rs_time operator / ( const rs_time& t, double d );
  friend double operator / ( const rs_time& t1, const rs_time& t2 );


  // print operator

  void print(::std::ostream& os) const;
};


::std::ostream& operator << ( ::std::ostream& os, const rs_time& t );
rs_time rs_time_stamp();

const rs_time RS_ZERO_TIME = rs_time(0);

#endif
