/**
 * UNS - CNRS
 * Copyright 2015 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    config_param_group.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2015-04-02
 * @section DESCRIPTION
 *			Config Param Group description
 */

#ifndef CONFIG_PARAM_GROUP_H
#define CONFIG_PARAM_GROUP_H

#include <string>
#include <set>
#include <map>
#include <vector>
#include "config_fct_point.h"

using namespace std;

class Config_param_group {
	
	string groupName;
	bool commonDomain;
	Config_fct_point *nominalFctPoint;
	vector<Config_fct_point*>* powerFctList;

public:
	
	 Config_param_group(string groupName_, bool commonUnit_, Config_fct_point* nominalFctPoint_, vector<Config_fct_point*>* powerFctList_) {
		groupName = groupName_;
		commonDomain = commonUnit_;
		nominalFctPoint = nominalFctPoint_;
		powerFctList = powerFctList_;
	}
	
	Config_param_group(string groupName) {
		groupName = groupName;
		commonDomain = false;
		nominalFctPoint = new Config_fct_point(0,0);
		powerFctList = new vector<Config_fct_point*>();
	}
	
	Config_param_group(Config_param_group& cfg) {
		groupName = cfg.groupName;
		commonDomain = cfg.commonDomain;
		nominalFctPoint = new Config_fct_point(cfg.nominalFctPoint);
		
		powerFctList = new vector<Config_fct_point*>();
		for (unsigned int i=0; i<(unsigned int)cfg.powerFctList->size(); i++)
			powerFctList->push_back(new Config_fct_point(cfg.powerFctList->at(i)));
	}
	
	string toString() {
		string act = groupName;
		if (commonDomain == true)
			act += " (c)";
		return act;
	}
	
	bool equals(Config_param_group cp) {
		return (groupName.compare(cp.groupName) == 0);
	}
	
	void setGroupName(string val) {
		groupName = val;
	}	
	
	string getGroupName() {
		return groupName;
	}	
	
	void setCommonDomain(bool val) {
		commonDomain = val;
	}	
	
	bool isCommonDomain() {
		return commonDomain;
	}	
	
	void setNominalFctPoint(Config_fct_point* val) {
		nominalFctPoint = val;
	}	
	
	Config_fct_point& getNominalFctPoint() {
		return *nominalFctPoint;
	}	
	
	void setFctPointList(vector<Config_fct_point*>* val) {
		powerFctList = val;
	}	
	
	const vector<Config_fct_point*>& getFctPointList() {
		return *powerFctList;
	}

};

#endif
