/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    utils.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-05-20
 * @section DESCRIPTION
 *			Some useful functions
 */

#include "utils.h"

using namespace std;
//using namespace sc_dt;
//using namespace sc_core;
//using namespace tlm;

//void Utils::check_transaction(tlm_generic_payload& trans) {
//
//	// Check error response
//	if (trans.is_response_error()) {
//		char txt[100];
//		sprintf(txt, "Transaction returned with error, response status = %s", trans.get_response_string().c_str());
//		SC_REPORT_ERROR("TLM-2", txt);
//    }
//	
//	tlm::tlm_command cmd = trans.get_command();
//	sc_dt::uint64    adr = trans.get_address();
//	int*             ptr = reinterpret_cast<int*>(trans.get_data_ptr());
//
//	// Allow the memory manager to free the transaction object
//	trans.release();
//}

int Utils::atoi(string str) {
	istringstream iss(str);
	int value;
	iss >> value;
	return value;
}

double Utils::atod(string str) {
	istringstream iss(str);
	double value;
	iss >> value;
	return value;
}

string Utils::itoa(int val) {
	ostringstream oss;
	oss << val;
	return oss.str();
}

string Utils::ftoa(float val) {
	ostringstream oss;
	oss << val;
	return oss.str();
}




//sc_bigint<TRACE_LV_SIZE> Utils::string_to_ascii(string str) {

//	sc_bigint<TRACE_LV_SIZE> result = 0;

//	for(int i = 0; i < (int) str.size(); i++) {
//		result = (result << 8) + str.at(i);
//	}

//	return result;
//}

bool generate_logfile(void) {

#ifdef GENERATE_LOG_FILE
	return true;
#else 
	return Utils::VERBOSE_MODE;
#endif
}

rs_time Utils::maxTime(rs_time a, rs_time b) {
	return ((a > b) ? a : b);
}
