#ifndef RS_EVENT
#define RS_EVENT

#include <mutex>
#include <condition_variable>
#include <chrono>
#include "rs_time.h"

class rs_event {
private :
	std::mutex mtx;
	std::condition_variable_any* cv;
	bool locking;
	int i;
public :
	rs_event():
		mtx(),
		cv(NULL),
		locking(true),
		i(0)
		{}

	rs_event(bool _lock):
		mtx(),
		cv(NULL),
		locking(_lock)
		{}
//	~rs_envent();
	
	inline void wait(void){
		mtx.lock();
		if(cv != NULL){ 
			exit(-1);
		}
		else{
			cv = new std::condition_variable_any;
			cv->wait(mtx);
		}
		mtx.unlock();
	}

	inline void wait_for(rs_time time_out){
		mtx.lock();
		if(cv != NULL){ 
			exit(-1);
		}
		else{
			cv = new std::condition_variable_any;
			if(cv->wait_for(mtx,std::chrono::microseconds(time_out.value())) == std::cv_status::timeout){
				cv = NULL;
			}
		}
		mtx.unlock();
	}

	inline void notify(void){
		mtx.lock();
		if (cv != NULL){
			cv->notify_one();
			delete cv;
			cv = NULL;
		}
		mtx.unlock();
	}
};

#endif
