
/***************************************************/
/* Add Waiting Queue Handler for RECOMIN_WAITING_QUEUE_HANDLER Strategy 
 */

WAITING_QUEUE_HANDLER(RECOMIN_WAITING_QUEUE_HANDLER) {

	/* USER : Scheduling Algorithm : Update Waiting Queue */
	CALL_SCHEDULING_ALGORITHM(RECOMIN_WAITING_QUEUE_HANDLER);

	// SCHED : exit if no solution found at this moment (wait for the next call)
	bool exitCondition = false;
	Return_mapping_information mapping;

	scheduler.Scheduler_reset_current_position_in_waiting_queue();

	//while(scheduler.Scheduler_are_tasks_waiting() && !exitCondition) {
	while(scheduler.Scheduler_last_task_waiting() == false && !exitCondition) {

		//!\ NECESSARY SYNC
		wait(SC_ZERO_TIME);

		/* DISPLAY : Console, Waiting Task Queue */
		scheduler.Scheduler_display_waiting_queue();

		/* SCHED : Get request with the highest priority inside waiting queue */
		SchedulerRequest current_request = scheduler.Scheduler_next_task_waiting();

		/* SCHED : Retrieve task ID associated with scheduler request */
		int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

		/* TRACE : Set scheduler active for this task */
		scheduler.Scheduler_set_scheduler_active(waiting_task_id);

		switch(scheduler.Scheduler_get_task_state(waiting_task_id)) {

			case STATIC:
				// Should not happen here, should be considered directly in b_transport
				SC_REPORT_FATAL("TLM-2.0", "Reconfiguration manager: Static state should not happen at this point!");
			
			case IDLE:				/* placée sur le FPGA et en attente de la nouvelle période */
			case WAITING:			/* placée sur le FPGA et en attente des communications */
			case CONTEXT_SAVE:		/* ok */
			case CONTEXT_RESTORE:	/* ok */
			case QUEUED:			/* elle est en file d'attente pour etre configurée (Not Reconfigurable Task) */
			case CONFIG:			/* En cours de configuration (Not Reconfigurable Task) */
			case RUNNING:			/* ACTIVE (instantiée) (Not Reconfigurable Task) */

				/* DISPLAY : Console, Precedence list vector */
				scheduler.Scheduler_print_finished_precedence_vector(waiting_task_id);

				/* SCHED: Check if the owner of the request is the same as the one that initiated reconfiguration. 
				 * If so, wait till end of computation (new execution request)
				 */
				if(scheduler.Scheduler_has_task_already_requested_mapping(waiting_task_id, current_request.get_request_owner())) {
					/* DISPLAY : LOG File */
					#ifdef GENERATE_LOG_FILE
						scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": " << scheduler.Scheduler_get_name() << ": Packet n+1 -> Task is still in RUNNING state, return" << endl;
					#endif

					/* SCHED : Exit Scheduler */
					//REM: la tache refait une demande alors que le paquet d'avant n'est pas encore traité par la tache suivante
					exitCondition = true;

					/* SCHED : Simulate scheduler execution time and energy consumption */
					scheduler.Scheduler_emulate_scheduler_behavior();
				} 
				else {
					/*
					 * Vérifie que la requete vient d'une autre tache
					 * On ne peut pas etre RUNNING ici
					 */
					if(waiting_task_id != current_request.get_request_owner()) {
						/* DISPLAY : LOG File */
						#ifdef GENERATE_LOG_FILE
							scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": " << scheduler.Scheduler_get_name() << ": Packet n -> Task is already in RUNNING state, removing task from list" << endl;
						#endif

						/* SCHED : Remove highest priority request from the queue */
						scheduler.Scheduler_erase_current_task_waiting();

						/* SCHED : Simulate scheduler execution time and energy consumption */
						scheduler.Scheduler_emulate_scheduler_behavior();

						/* SCHED : notification (Notify precedence) */
						//REM: si tache running, on prévient le module précédent (request owner) qu'il peut envoyer ces données
						if(scheduler.Scheduler_get_task_state(waiting_task_id) == IDLE ||
							scheduler.Scheduler_get_task_state(waiting_task_id) == WAITING ||
							scheduler.Scheduler_get_task_state(waiting_task_id) == CONTEXT_RESTORE) {

							/* SCHED : Direct Notification  */
							scheduler.Scheduler_notify_request_owner_module_ready(current_request.get_request_owner(), waiting_task_id);
						
						} 
						else {
							
							/* SCHED : Notification after CONFIG */
							//REM: ajoute le request owner à la liste des prédécesseurs qui sont prets à envoyer les données
							scheduler.Scheduler_add_finished_precedence(waiting_task_id, current_request.get_request_owner());
						}
					} 
					else {
						/* SCHED : Preemption only, should happen here 
						 * during transitory states CONTEXT_SAVE & CONTEXT_RESTORE --> Do nothing 
						 */						
						exitCondition = true;
					}
				}

				break;

			case PREEMPTED_MAPPED:	/* Atteint un pt de préemption et en attente d'une décision du scheduler */
			case MAPPED:			/* Not Reconfigurable Task */

				/* DISPLAY : LOG File */
				#ifdef GENERATE_LOG_FILE
					scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": " << scheduler.Scheduler_get_name() << ": Task is in MAPPED state, no reconfiguration needed" << endl;
				#endif

				/* SCHED : Remove highest priority request from the queue */
				scheduler.Scheduler_erase_current_task_waiting();

				/* SCHED : Simulate scheduler execution time and energy consumption */
				scheduler.Scheduler_emulate_scheduler_behavior();

				/* TRACE : Changes a task from MAPPED to RUNNING state. */
				scheduler.Scheduler_rerun_task(current_request);

				break;

			case PREEMPTED_INACTIVE:	/* préemté et enlever de la RZ/Proc */
			case INACTIVE:				/* fin d'exécution ou au départ */
				
				//REM: au départ, toutes les taches sont PREEMPTED_INACTIVE ou INACTIVE.
				//REM: on prend les décisions concernant le mapping

				/* DISPLAY : LOG File */
				#ifdef GENERATE_LOG_FILE
					scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": " << scheduler.Scheduler_get_name() << ": Task is in INACTIVE/PREEMPTED_INACTIVE state" << endl;
				#endif

				//
				// MAPPING DECISIONS TAKEN HERE
				//
				mapping = CALL_MAPPING_ALGORITHM(RECOMIN_WAITING_QUEUE_HANDLER);

				if (mapping.RZ_found() == true) {
				
					if (mapping.hasCfgTcfPt() == true) {

						/* Update Fct Point */ 
						RZ* rz = mapping.get_implementation_RZ();
						if (scheduler.Scheduler_exist_rz_properties(rz) == true) {
							RZ_config rz_config = scheduler.Scheduler_get_rz_properties(rz);
							Config_param_group* cfgParamGrp = rz_config.getConfigDomain();
							if (cfgParamGrp != NULL) {
								if (cfgParamGrp->isCommonDomain() == true) {
									// CommonDomain true
									string groupName = rz->getGroupDomainName();
									Config_fct_point fctPt = mapping.getConfigFctPoint();
									if (fctPt.equals(rz->getConfigFctPoint()) == false) {
										// Fct Pt change
										vector<RZ *> rz_table = scheduler.Scheduler_get_all_rz_vector();
										// Update Fct Pt for all RZs (for same group)
										for (unsigned int i=0; i<rz_table.size(); i++) {
											RZ *c_rz = rz_table.at(i);
											if (groupName.compare(c_rz->getGroupDomainName()) == 0) {
												// Same Group
												c_rz->setConfigFctPoint(mapping.getConfigFctPoint());
												
												// Notify modification of parameters to the waiting module
												scheduler.Scheduler_send_update_parameters_to_module(c_rz);
											}
										}
									}
								}
								else {
									// CommonDomain false
									rz->setConfigFctPoint(mapping.getConfigFctPoint());

									// Notify modification of parameters to the waiting module
									scheduler.Scheduler_send_update_parameters_to_module(rz);

								}
							}
						}
					}
				
					/* SCHED : Remove highest priority request from the queue */
					scheduler.Scheduler_erase_current_task_waiting();

					/* SCHED : Simulate scheduler behavior (execution time of the scheduler) BEFORE configuring task for timing accuracy */
					scheduler.Scheduler_emulate_scheduler_behavior();

					/* SCHED : Launch task configuration through either HW of SW reconfiguration unit. */  
					scheduler.Scheduler_configure_task(mapping.get_implementation_RZ(), waiting_task_id, mapping.get_implementation_ID(), current_request.get_request_owner());
				}
				else {

					/* RZ not found !
					* AMAP mapping cannot be satisfied,
					* No solutions at this time...
					*/

					/* DISPLAY : LOG File */
					#ifdef GENERATE_LOG_FILE
						scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": " << scheduler.Scheduler_get_name() << " cannot allocate " << current_request.getName() << "... Exiting" << endl;
					#endif
					
					if (mapping.exit_mapping_algorithm() == true)
						exitCondition = true;

					/* SCHED : Simulate scheduler execution time and energy consumption */
					scheduler.Scheduler_emulate_scheduler_behavior();
				}
				
				break;

			default:
				SC_REPORT_FATAL("TLM-2", "Manager cannot recognize task state");
		}

		/* DISPLAY : Console */
		scheduler.Scheduler_display_task_state_table();
		scheduler.Scheduler_display_rz_current_module_table();
	}

}
