FORTRESS_HEADER

#include "user_parameters.h"
#include "simulation_controller.h"
#include "reconfigurable_zone.h"
#include "testbench_in.h"
#include "testbench_out.h"
#include "module.h"
#include "reconf_threads.h"
#include "configuration_file_parser.h"
#include "reconfiguration_manager.h"
#include "generation_helper.h"
#include "testbench_algorithms.h"
#include "module_algorithms.h"
#include "application.h"
#include "user_monitoring.h"

#include "fpga.h"
#include "task.h"

#include <sstream>
#include <fstream>
#include <string>
#include <map>

bool Utils::VERBOSE_MODE					= FORTRESS_VERBOSE_MODE;

FORTRESS_ALGO_DECLARATION

int sc_main(int argc, char* argv[]) {

	string simulationName;

	if(argc == 2) {
		cout << "RZ file to parse: " << argv[1] << endl;
		simulationName = "";
	} else if(argc == 3) {
		cout << "RZ file to parse: " << argv[1] << endl;
		cout << "Simulation name: " << argv[2] << endl;
		simulationName = argv[2];
	} else {
		cout << "Need parameters. Usage: ./exec path_to_RZ_file simulation_name" << endl;
		return -1;
	}
	
	string path(argv[1]);

	/* Log Files */
FORTRESS_LOGFILE
	/* VCD Trace Files */
FORTRESS_TRACEFILE
	/* RZ Properties */
	map<string, RZ_config*> rz_cfg_table;
	RZ_config::initRZConfigTable(rz_cfg_table);
	
	/* Module Instances Declaration*/
FORTRESS_MODULE_DECL
	/* Read RZ Configuration File */
	vector<RZ *> rz_table;
	vector<Task> task_table;
	FPGA* fpga = new FPGA();
	if(readRZConfigurationFile(path, rz_table, task_table, fpga) != 0) {
		cerr << "ERROR: Unable to read RZ configuration file, exiting..." << endl;
		return -1;
	}
	Reconfiguration_manager manager("Reconfiguration_manager", rz_table, task_table, WAITING_QUEUE_HANDLER_REF(FORTRESS_WAITING_QUEUE_HANDLER), fpga, fout, tf, rz_cfg_table);
	
FORTRESS_APPLICATIONS_LIST

	/* Application Defined */
	manager.applicationDefined();
	
	/* DEBUG TRACE */
FORTRESS_DEBUG_TRACE
	/* Activate Trace */
	manager.activate_trace();

	/* Simulator Configuration */
FORTRESS_MANAGER_ATTRIBUTES

FORTRESS_OFFSET_HYPERPERIOD

FORTRESS_MONITORING
	/* Start Simulation */
	sc_start(FORTRESS_MAX_SIMULATION_TIME, SC_SEC);

	/* End of Simulation */
	fout << "Simulation ended at time " << sc_time_stamp() << endl;
	bool simOK(manager.isSimulationOK());
	if (simOK)
		fout << "Simulation successful" << endl;
	else
		fout << "Simulation failed" << endl;

	Reconfiguration_manager::verifySimulationTimes();
		
	/* Display Information */
	manager.update_occupation_rate_end_simulation();
	manager.display_occupation_rates();
	manager.generateSimulationResultFile();
FORTRESS_GENERATE_RESULT_FILES
	/* Flush Streams */
	fout.flush();

	/* Close files */
	fout.close();
	sc_close_vcd_trace_file(tf);

FORTRESS_DELETE_APPLICATIONS_LIST	
	delete fpga;
	
	if(simOK)
		return RECOSIM_SIMULATION_SUCCESS;
	else
		return RECOSIM_SIMULATION_FAILED_ERRCODE;
}


