/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    scheduler_request.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-03-18
 * @section DESCRIPTION
 *			A scheduler request
 */

#include "scheduler_request.h"
using namespace std;

int SchedulerRequest::get_request_owner(void) const{
	return requestOwner;
}

// Task_priority_comparator_interface
rs_time SchedulerRequest::get_deadline_time(void) const {
	return taskToMap->get_deadline_time();
}

rs_time SchedulerRequest::get_task_deadline(void) const {
	return taskToMap->get_task_deadline();
}

rs_time SchedulerRequest::get_task_period(void) const {
	return taskToMap->get_task_period();
}

rs_time SchedulerRequest::get_task_offset(void) const {
	return taskToMap->get_task_offset();
}

int SchedulerRequest::get_task_priority(void) const {
	return taskToMap->get_task_priority();
}

// Task_to_schedule_interface
bool SchedulerRequest::has_implementation(TaskImplementation& impl) const {
	return taskToMap->has_implementation(impl);
  //return false;
}

bool SchedulerRequest::fits(RZ *rz) {
        return false;
	//return taskToMap->fits(rz);
}

string SchedulerRequest::getName(void) const {
	return taskToMap->getName();
}

rs_time SchedulerRequest::get_new_period_start_time(void) const {
	return taskToMap->get_new_period_start_time();
}

void SchedulerRequest::set_task_priority(int p) {
	taskToMap->set_task_priority(p);
}

ModuleImplementation SchedulerRequest::get_current_implementation(void) {
	return taskToMap->get_current_implementation();
}

bool SchedulerRequest::has_current_implementation(void) {
	return taskToMap->has_current_implementation();
}
	
vector<int> SchedulerRequest::getFollowingList(void) const {
	return taskToMap->getFollowingList();
}

vector<int> SchedulerRequest::getPrecedingList(void) const {
	return taskToMap->getPrecedingList();
}
