/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    memory_manager.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-05-20
 * @section DESCRIPTION
 *			Implementation file of the memory manager
 */

#include "memory_manager.h"

using namespace std;

Memory_manager::gp_t* Memory_manager::allocate() {

	gp_t* ptr;
	if (free_list) {
		ptr = free_list->trans;
		empties = free_list;
		free_list = free_list->next;
	} else {
		ptr = new gp_t(this);
	}
	return ptr;
}

void Memory_manager::free(gp_t* trans) {

	if (!empties) {
		empties = new access;
		empties->next = free_list;
		empties->prev = 0;
		if (free_list) free_list->prev = empties;
	}
	free_list = empties;
	free_list->trans = trans;
	empties = free_list->prev;
}
