/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    utils.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-05-20
 * @section DESCRIPTION
 *			Some useful functions
 */

#ifndef UTILS_H
#define UTILS_H

#include <string>
#include <map>
#include <sstream>
//#define RECOSIM_PART

// Only for middleware
#define MIDDLEWARE_GEN

#ifdef MIDDLEWARE_GEN
// Middleware
#include "rs_event.h"
#define wait_for_time(ttt) this_thread::sleep_for(chrono::microseconds(ttt.value()))
#define wait_semaphore_ptr(sem) sem->wait()
#define post_semaphore_ptr(sem) sem->notify()
#define wait_semaphore(sem) sem.wait()
#define post_semaphore(sem) sem.notify()

#define TB_IF_wait_all_responses_received_event(foo) tb_interface.TB_IF_all_responses_received_wait()
#define TB_IF_wait_all_responses_received_event_timeout(timeout) tb_interface.TB_IF_wait_transaction_received_event(timeout)

#define WAIT_RS_ZERO_TIME(foo)

#define START_BENCH(foo) tb_interface.wait_on_sinc()
#define START_ALGORITHM(foo) user_algo_interface.set_pid()

#else 
// SystemC
#define rs_time sc_time
#define RS_US SC_US
#define RS_MS SC_MS
#define RS_SEC SC_SEC
#define RS_ZERO_TIME SC_ZERO_TIME
#define rs_time_stamp sc_time_stamp
#define rs_event sc_semaphore

#define wait_for_time(ttt) wait(ttt)

#define wait_semaphore_ptr(sem) sem->wait()
#define post_semaphore_ptr(sem) sem->post()
#define wait_semaphore(sem) sem.wait()
#define post_semaphore(sem) sem.post()

#define TB_IF_wait_all_responses_received_event(foo) wait(tb_interface.TB_IF_all_responses_received_event())
#define TB_IF_wait_all_responses_received_event_timeout(timeout) wait(timeout, tb_interface.TB_IF_transaction_received_event())

#define WAIT_RS_ZERO_TIME(foo) wait(SC_ZERO_TIME)

#define START_BENCH(foo)
#define START_ALGORITHM(foo)

#endif


//#include <systemc>
//#include "tlm.h"

#define IS_VERBOSE_MODE() (Utils::VERBOSE_MODE)

#include "rs_time.h"
#include "config.h"
//#include "user_parameters.h"

//#define DEBUG

//#define GENERATE_LOG_FILE

using namespace std;

bool generate_logfile(void);

enum ManagerToModuleCommands{MANAGER_COMMAND_SCHEDULING};
enum ModuleToManagerCommands{MANAGER_UPLINK_TASK_PREEMPTION, MANAGER_UPLINK_TASK_END_COMPUTATION, MANAGER_UPLINK_TASK_CHECK_SOCKET, MANAGER_UPLINK_ALGO_STATE_UPDATE};
enum TestbenchToManagerCommands{TB_TO_MANAGER_CHECK_SOCKET, TB_TO_MANAGER_ALGORITHM_COMMAND};

// ERRCODES
const int RECOSIM_SIMULATION_SUCCESS = 0;			/*< Simulation success */
const int RECOSIM_SIMULATION_FAILED_ERRCODE = 1;	/*< QoS or consumption failure */
const int RECOSIM_NOT_ALL_TASKS_HOSTED_ERRCODE = 2;	/*< Bad RZ/processor subset */
const int RECOSIM_INTERNAL_ERROR_ERRCODE = 3;		/*< Internal error, should not happen (error with RecoSim configuration/init) */
const int RECOSIM_TESTBENCH_CHECK_FAILED = 4;		/*< Testbench check failed (e.g. data received different than what was expected) */

class Utils {

public:
	static bool VERBOSE_MODE;

	static int atoi(std::string);
	static double atod(std::string);
	static std::string itoa(int);
	static std::string ftoa(float val);
	//static void check_transaction(tlm::tlm_generic_payload& trans);
	//static sc_dt::sc_bigint<TRACE_LV_SIZE> string_to_ascii(std::string str);
	static rs_time maxTime(rs_time a, rs_time b);
};

#endif
