#ifndef RS_BUFFER
#define RS_BUFFER

#include <iostream>
#include <mutex>
#include <condition_variable>


template<typename T>
class rs_buffer {
private :
	T val;
	T val_tmp;
	std::mutex mtx;
	std::condition_variable_any cv;

	bool predic();
	
public :
	rs_buffer():
	mtx(),
	cv(),
	val(),
	val_tmp()
	{}

	void write(T up_val);
	const T&    read(void) const;
	void wait_value_change(void);

	rs_buffer<T>& operator = (const T& a)
	{write(a); return *this;}
};

template<typename T>
void rs_buffer<T>::write(T up_val){
//	std::cout << "buffer change" << std::endl;
	mtx.lock();
//	std::cout << "buffer lock" << std::endl;
	val_tmp = up_val;
	cv.notify_one();
	mtx.unlock();
}

template<typename T>
bool rs_buffer<T>:: predic(){
	if (val == val_tmp) return false;
	return true;
}
template<typename T>
void rs_buffer<T>::wait_value_change(void){
//	std::cout << "buffer wait change" << std::endl;
	mtx.lock();
	cv.wait(mtx,[this](){return predic();});
	val = val_tmp;
	mtx.unlock();
}

template<typename T>
const T& rs_buffer<T>::read(void) const{
 return val;
}
#endif
