/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconf_threads.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-07-01
 * @section DESCRIPTION
 *			All reconfigurable threads
 */

#ifndef RECONF_THREADS_H
#define RECONF_THREADS_H

#include <thread>
#include <rs_event.h>
#include "reconf_thread_interface.h"
#include "user_algorithm_interface.h"
#include "utils.h"
#include <sched.h>

template<int Ni, int No> void reconf_thread_standard(Reconf_thread_interface &reconf_interface, User_algorithm_interface<Ni, No> &user_algo_interface) {

	std::thread* p_handle = NULL;
	//sc_process_handle p_handle;
	user_algo_interface.get_logfile() << reconf_interface.get_name() << ": Waiting config update..." << endl;
	user_algo_interface.get_logfile()<< this_thread::get_id() << endl;

	while(true) {
		reconf_interface.wait_configuration_updated();

		if(p_handle != NULL) {
			// Kill thread
#ifdef GENERATE_LOG_FILE
			user_algo_interface.get_logfile() << reconf_interface.get_name() << ": Waiting for the end of previous user algorithm..." << endl;
#endif
			p_handle->join();
			user_algo_interface.rez_pid();
#ifdef GENERATE_LOG_FILE
			user_algo_interface.get_logfile() << reconf_interface.get_name() << ": Previous user algorithm terminated successfully!" << endl;
#endif
		}

		void *user_interface_ptr = &user_algo_interface;

#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << reconf_interface.get_name() << ": Configuration update: Algorithm " << reconf_interface.get_current_implementation_id() 
			<< " (" << reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_name() << ")" << endl;
#endif
		//reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_algorithm_thread_ptr()( user_interface_ptr);
		p_handle = new std::thread(reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_algorithm_thread_ptr(), user_interface_ptr);
		//p_handle = sc_spawn(sc_bind(reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_algorithm_thread_ptr(), user_interface_ptr));
		std::thread::id module_id = p_handle->get_id();
		cpu_set_t cpuset;
		CPU_ZERO(&cpuset);
		CPU_SET(0,&cpuset);
		//sched_setaffinity((pid_t)module_id,sizeof(cpuset),&cpuset);
		user_algo_interface.get_logfile() << "\t" << reconf_interface.get_name() << " Thread ID : " <<  hex << module_id << dec << endl;

		//reconf_interface.finish_configuration();
	}
	user_algo_interface.get_logfile()<< "end of reconf thread"  << endl;
}

#endif
