/**
 * UNS - CNRS
 * Copyright 2015 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    config_processor.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2015-04-02
 * @section DESCRIPTION
 *			Config Fct Point description
 */

#ifndef CONFIG_PROCESSOR_H
#define CONFIG_PROCESSOR_H

#include <string>
#include <set>
#include <map>
#include "config_processor_name.h"

using namespace std;

class Config_processor {

	string instName;			// instance (Core_0)
	Config_processor_name* cfg_proc_name;
	string powerGroupName;
	float contextSwitchTime;
	string interfaces;

public:

	Config_processor(string instName_, Config_processor_name* cfg_proc_name_, float contextSwitchTime_, string interfaces_, string powerGroupName_) {
		instName = instName_;
		cfg_proc_name = cfg_proc_name_;
		powerGroupName = powerGroupName_;
		contextSwitchTime = contextSwitchTime_;
		interfaces = interfaces_;
	}
	
	Config_processor(string instName_, Config_processor_name* cfg_proc_name_, string powerGroupName_) {
		instName = instName_;
		cfg_proc_name = cfg_proc_name_;
		powerGroupName = powerGroupName_;
		contextSwitchTime = 0;
		interfaces = "";
	}
	
	Config_processor(Config_processor cfgProc, string instName) {
		Config_processor(instName, new Config_processor_name(cfgProc.cfg_proc_name), cfgProc.contextSwitchTime, cfgProc.interfaces, cfgProc.powerGroupName);
	}
	
	string toString() {
		string act = "";
		if (hasInterfaces() == true)
			return instName + " " + act + " [ Processor: " + cfg_proc_name->getProcessorName() + ", Power Domain: " + powerGroupName + ", Context Switch Time = " + Utils::ftoa(contextSwitchTime) + " us, Interfaces = " + interfaces + " ]";
		else
			return instName + " " + act + " [ Processor: " + cfg_proc_name->getProcessorName() + ", Power Domain: " + powerGroupName + ", Context Switch Time = " + Utils::ftoa(contextSwitchTime) + " us ]";
	}
	
	bool hasInterfaces() {
		return interfaces.length() > 0;
	}
	
	bool equals(Config_processor cp) {
		return (instName.compare(cp.getInstanceName()) == 0);
	}

	bool identical(Config_processor cp) {
		return instName.compare(cp.getInstanceName()) == 0 &&
				cfg_proc_name->getProcessorName().compare(cp.cfg_proc_name->getProcessorName()) == 0 &&
				contextSwitchTime == cp.getContextSwitchTime() &&
				interfaces.compare(cp.getInterfaces()) == 0;
	}
	
	void setInstanceName(string val) {
		instName = val;
	}	
	
	string getInstanceName() {
		return instName;
	}	
	
	void setType(Config_processor_name* val) {
		cfg_proc_name = val;
	}
	
	Config_processor_name* getType() {
		return cfg_proc_name;
	}
	
	void setContextSwitchTime(float val) {
		contextSwitchTime = val;
	}
	
	float getContextSwitchTime() {
		return contextSwitchTime;
	}
	
	void setInterfaces(string val) {
		interfaces = val;
	}
	
	string getInterfaces() {
		return interfaces;
	}
	
	void setPowerGroupName(string val) {
		powerGroupName = val;
	}

	string getPowerGroupName() {
		return powerGroupName;
	}
	
};

#endif
