/*
 * Decompiled with CFR 0.152.
 */
package jfb.gmf.modulesystem.diagram.application;

import Modulesystem.diagram.commands.InputDialogNewProject;
import Modulesystem.diagram.commands.InputDialogOpenProject;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import java.io.File;
import java.util.Iterator;
import jfb.gmf.modulesystem.diagram.part.Messages;
import jfb.gmf.modulesystem.diagram.part.ModulesystemCreationWizard;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.console.MessageConsoleStream;

public class DiagramEditorActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction toggleCoolbarAction;

    public DiagramEditorActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    private IWorkbenchWindow getWindow() {
        return this.getActionBarConfigurer().getWindowConfigurer().getWindow();
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.toggleCoolbarAction = ActionFactory.TOGGLE_COOLBAR.create(window);
        this.register((IAction)this.toggleCoolbarAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.register((IAction)ActionFactory.CLOSE.create(window));
        this.register((IAction)ActionFactory.CLOSE_ALL.create(window));
        this.register((IAction)ActionFactory.SAVE.create(window));
        this.register((IAction)ActionFactory.SAVE_AS.create(window));
        this.register((IAction)ActionFactory.SAVE_ALL.create(window));
        this.register((IAction)ActionFactory.QUIT.create(window));
        this.register((IAction)ActionFactory.UNDO.create(window));
        this.register((IAction)ActionFactory.REDO.create(window));
        this.register((IAction)ActionFactory.CUT.create(window));
        this.register((IAction)ActionFactory.COPY.create(window));
        this.register((IAction)ActionFactory.PASTE.create(window));
        this.register((IAction)ActionFactory.DELETE.create(window));
        this.register((IAction)ActionFactory.SELECT_ALL.create(window));
        this.register((IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
        this.register((IAction)ActionFactory.PRINT.create(window));
    }

    protected void fillMenuBar(IMenuManager menu) {
        MenuManager menuX = new MenuManager(Messages.ApplicationMenuName_File, "file");
        menuX.add((IContributionItem)new GroupMarker("fileStart"));
        MenuManager menuXX = new MenuManager(Messages.ApplicationMenuName_New, "new");
        menuXX.add((IContributionItem)new GroupMarker("additions"));
        menuX.add((IContributionItem)menuXX);
        menuX.add((IContributionItem)new GroupMarker("fileStart"));
        menuXX = new MenuManager("Open", "open");
        menuXX.add((IContributionItem)new GroupMarker("additions"));
        menuX.add((IContributionItem)menuXX);
        menuX.add((IContributionItem)new Separator());
        menuX.add((IContributionItem)new GroupMarker("additions"));
        menuX.add((IContributionItem)new Separator());
        menuX.add(this.getAction(ActionFactory.CLOSE.getId()));
        menuX.add(this.getAction(ActionFactory.CLOSE_ALL.getId()));
        menuX.add((IContributionItem)new Separator());
        menuX.add(this.getAction(ActionFactory.SAVE.getId()));
        menuX.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        menuX.add(this.getAction(ActionFactory.SAVE_ALL.getId()));
        menuX.add((IContributionItem)new Separator());
        menuX.add(this.getAction(ActionFactory.QUIT.getId()));
        menuX.add((IContributionItem)new GroupMarker("fileEnd"));
        menu.add((IContributionItem)menuX);
        menuX = new MenuManager(Messages.ApplicationMenuName_Edit, "edit");
        menuX.add((IContributionItem)new GroupMarker("editStart"));
        menuX.add(this.getAction(ActionFactory.UNDO.getId()));
        menuX.add(this.getAction(ActionFactory.REDO.getId()));
        menuX.add((IContributionItem)new GroupMarker("undo.ext"));
        menuX.add((IContributionItem)new Separator());
        menuX.add(this.getAction(ActionFactory.CUT.getId()));
        menuX.add(this.getAction(ActionFactory.COPY.getId()));
        menuX.add(this.getAction(ActionFactory.PASTE.getId()));
        menuX.add((IContributionItem)new GroupMarker("cut.ext"));
        menuX.add((IContributionItem)new Separator());
        menuX.add(this.getAction(ActionFactory.DELETE.getId()));
        menuX.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        menuX.add((IContributionItem)new Separator());
        menuX.add((IContributionItem)new GroupMarker("add.ext"));
        menuX.add((IContributionItem)new GroupMarker("editEnd"));
        menuX.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)menuX);
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void fillCoolBar(ICoolBarManager toolBar) {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.toggleCoolbarAction));
        toolBar.setContextMenuManager((IMenuManager)popUpMenu);
        toolBar.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager toolBarX = new ToolBarManager();
        toolBarX.add((IContributionItem)new Separator("new.group"));
        toolBarX.add((IContributionItem)new GroupMarker("new.ext"));
        toolBarX.add((IContributionItem)new GroupMarker("save.group"));
        toolBarX.add(this.getAction(ActionFactory.SAVE.getId()));
        toolBarX.add((IContributionItem)new GroupMarker("save.ext"));
        toolBarX.add(this.getAction(ActionFactory.PRINT.getId()));
        toolBarX.add((IContributionItem)new GroupMarker("print.ext"));
        toolBarX.add((IContributionItem)new Separator("additions"));
        toolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarX, "org.eclipse.ui.workbench.file"));
        toolBar.add((IContributionItem)new GroupMarker("additions"));
        toolBar.add((IContributionItem)new GroupMarker("group.nav"));
        toolBar.add((IContributionItem)new GroupMarker("group.editor"));
        toolBar.add((IContributionItem)new GroupMarker("group.help"));
        toolBarX = new ToolBarManager();
        toolBarX.add((IContributionItem)new Separator("group.help"));
        toolBarX.add((IContributionItem)new GroupMarker("group.application"));
    }

    private static boolean openEditor(IWorkbench workbench, URI fileURI) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = workbench.getEditorRegistry().getDefaultEditor(fileURI.toFileString());
        if (editorDescriptor == null) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Messages.DiagramEditorActionBarAdvisor_DefaultFileEditorTitle, (String)NLS.bind((String)Messages.DiagramEditorActionBarAdvisor_DefaultFileEditorMessage, (Object)fileURI.toFileString()));
            return false;
        }
        try {
            page.openEditor((IEditorInput)new URIEditorInput(fileURI), editorDescriptor.getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Messages.DiagramEditorActionBarAdvisor_DefaultEditorOpenErrorTitle, (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public static class AboutAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)Messages.DiagramEditorActionBarAdvisor_AboutDialogTitle, (String)Messages.DiagramEditorActionBarAdvisor_AboutDialogMessage);
        }
    }

    public static class NewDiagramAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            String current_project_path = FortressEnv.getProjectPath();
            if (current_project_path.isEmpty()) {
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                console.println("Error: No project opened !");
            }
            ModulesystemCreationWizard wizard = new ModulesystemCreationWizard();
            wizard.init(this.getWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(this.getWindow().getShell(), (IWizard)wizard);
            wizardDialog.open();
        }
    }

    public static class OpenAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            FileDialog fileDialog = new FileDialog(this.getWindow().getShell(), 4096);
            fileDialog.setFilterPath(FortressEnv.getProjectPath());
            fileDialog.open();
            if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                DiagramEditorActionBarAdvisor.openEditor(this.getWindow().getWorkbench(), URI.createFileURI((String)(String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName())));
            }
        }
    }

    public static class OpenProjectAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            FortressEnv.initFortressPath();
            Display display = PlatformUI.createDisplay();
            InputDialogOpenProject OpenProjectWindow = new InputDialogOpenProject(display, "Open project");
            OpenProjectWindow.open();
        }
    }

    public static class OpenURIAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(this.getWindow().getShell());
            if (loadResourceDialog.open() == 0) {
                Iterator i = loadResourceDialog.getURIs().iterator();
                while (i.hasNext()) {
                    DiagramEditorActionBarAdvisor.openEditor(this.getWindow().getWorkbench(), (URI)i.next());
                }
            }
        }
    }

    public static class ProjectAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            FortressEnv.initFortressPath();
            Display display = PlatformUI.createDisplay();
            InputDialogNewProject NewProjectWindow = new InputDialogNewProject(display, "New Project");
            NewProjectWindow.open();
        }
    }
}

