/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.xml.FortressBenchModule;
import fortress.xml.FortressConnection;
import fortress.xml.FortressModuleImplementation;
import java.util.Vector;

public class FortressNodeModule {
    String module_name;
    String deadline;
    String period;
    String priority;
    String begin_time;
    boolean static_module;
    boolean activated_trace;
    String tracefile;
    boolean enable_execution_module_signals_trace;
    String logfile;
    Vector<FortressConnection> outConnections;
    Vector<FortressConnection> inConnections;
    Vector<FortressModuleImplementation> hwImpl;
    Vector<FortressModuleImplementation> swImpl;

    public FortressNodeModule(String module_name, String deadline, String period, String priority, String begin_time, boolean static_module, boolean activated_trace, String tracefile, boolean enable_execution_module_signals_trace, String logfile, Vector<FortressConnection> outConnections, Vector<FortressModuleImplementation> hwImpl, Vector<FortressModuleImplementation> swImpl) {
        this.module_name = module_name;
        this.deadline = deadline;
        this.period = period;
        this.priority = priority;
        this.begin_time = begin_time;
        this.static_module = static_module;
        this.activated_trace = activated_trace;
        this.tracefile = tracefile;
        this.enable_execution_module_signals_trace = enable_execution_module_signals_trace;
        this.logfile = logfile;
        this.outConnections = outConnections;
        this.hwImpl = hwImpl;
        this.swImpl = swImpl;
        this.inConnections = null;
    }

    public Vector<FortressModuleImplementation> getHwImplementationList() {
        return this.hwImpl;
    }

    public Vector<FortressModuleImplementation> getSwImplementationList() {
        return this.swImpl;
    }

    public boolean equals(FortressBenchModule fmi) {
        return this.module_name.equals(fmi.getModuleName());
    }

    public boolean equals(FortressNodeModule fmi) {
        return this.module_name.equals(fmi.getModuleName());
    }

    public Vector<FortressConnection> getOutConnections() {
        return this.outConnections;
    }

    public int getOutputConnectionNumber() {
        return this.outConnections.size();
    }

    public Vector<FortressConnection> getOutFortressConnection(String targetModuleName) {
        Vector<FortressConnection> conOutList = new Vector<FortressConnection>();
        int i = 0;
        while (i < this.outConnections.size()) {
            if (this.outConnections.elementAt(i).getTargetModule().equals(targetModuleName)) {
                conOutList.add(this.outConnections.elementAt(i));
            }
            ++i;
        }
        return conOutList;
    }

    public boolean hasSuccessor() {
        return !this.outConnections.isEmpty();
    }

    public boolean hasSuccessorNode() {
        boolean toNode = false;
        int k = 0;
        while (k < this.outConnections.size()) {
            FortressConnection connection = this.outConnections.elementAt(k);
            toNode |= connection.isNodeModule();
            ++k;
        }
        return toNode;
    }

    public void setInConnections(Vector<FortressConnection> inConnections) {
        this.inConnections = inConnections;
    }

    public Vector<FortressConnection> getInConnections() {
        return this.inConnections;
    }

    public int getInputConnectionNumber() {
        return this.inConnections.size();
    }

    public String getModuleName() {
        return this.module_name;
    }

    public static String getDefaultDeadline() {
        return "10000";
    }

    public String getDeadline() {
        return this.deadline;
    }

    public static String getDefaultPeriod() {
        return "0";
    }

    public String getPriority() {
        return this.priority;
    }

    public static String getDefaultPriority() {
        return "0";
    }

    public String getPeriod() {
        return this.period;
    }

    public static String getDefaultBeginTime() {
        return "0";
    }

    public String getBeginTime() {
        return this.begin_time;
    }

    public static boolean isDefaultStaticModule() {
        return false;
    }

    public boolean isStaticModule() {
        return this.static_module;
    }

    public static boolean isDefaultActivatedTrace() {
        return true;
    }

    public boolean isActivatedTrace() {
        return this.activated_trace;
    }

    public static boolean isDefaultEnableExecutionModeSignalsTrace() {
        return false;
    }

    public boolean isEnableExecutionModeSignalsTrace() {
        return this.enable_execution_module_signals_trace;
    }

    public static String getDefaultTraceFile(String moduleName) {
        return String.valueOf(moduleName) + ".tra";
    }

    public String getTraceFile() {
        return this.tracefile;
    }

    public static String getDefaultLogFile(String moduleName) {
        return String.valueOf(moduleName) + ".log";
    }

    public String getLogFile() {
        return this.logfile;
    }
}

