/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

public class FPGAConstraints {
    FPGAConstraintsType type;
    int row;
    int column;
    int columnMax;

    public FPGAConstraints(int row, int column) {
        this.type = FPGAConstraintsType.RB;
        this.row = row;
        this.columnMax = column;
        this.column = column;
    }

    public FPGAConstraints(int row, int column, int columnMax) {
        this.type = FPGAConstraintsType.RANGE_RB;
        this.row = row;
        this.column = column;
        this.columnMax = columnMax;
    }

    public FPGAConstraints(FPGAConstraints fc) {
        this.type = fc.type;
        this.row = fc.row;
        this.columnMax = fc.columnMax;
        this.column = fc.column;
    }

    public FPGAConstraints(String row, String column) {
        this(Integer.parseInt(row), Integer.parseInt(column));
    }

    public FPGAConstraints(String row, String column, String columnMax) {
        this(Integer.parseInt(row), Integer.parseInt(column), Integer.parseInt(columnMax));
    }

    public boolean isRB() {
        return this.type == FPGAConstraintsType.RB;
    }

    public boolean isRangeRB() {
        return this.type == FPGAConstraintsType.RANGE_RB;
    }

    public int getRow() {
        return this.row;
    }

    public String getRowString() {
        return String.valueOf(this.row);
    }

    public int getColumn() {
        return this.column;
    }

    public String getColumnString() {
        return String.valueOf(this.column);
    }

    public int getColumnMax() {
        return this.columnMax;
    }

    public String getColumnMaxString() {
        return String.valueOf(this.columnMax);
    }

    public boolean equals(FPGAConstraints c) {
        if (this.type == FPGAConstraintsType.RB) {
            return c.row == this.row && c.column == this.column;
        }
        return c.row == this.row && c.column == this.column && c.columnMax == this.columnMax;
    }

    static enum FPGAConstraintsType {
        RB,
        RANGE_RB;

    }
}

