/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import java.util.Vector;

public class ConfigProcessor
implements Comparable<Object> {
    public static final String PROC_INST_PREFIX = "Core_";
    String instName;
    String type;
    String powerGroupName;
    String contextSwitchTime;
    String interfaces;
    boolean active;

    public ConfigProcessor(String instName, String type, String contextSwitchTime, String interfaces, boolean active, String powerGroupName) {
        this.instName = instName;
        this.type = type;
        this.powerGroupName = powerGroupName;
        this.contextSwitchTime = contextSwitchTime;
        this.interfaces = interfaces.trim();
        this.active = active;
    }

    public ConfigProcessor(String instName, String type, String powerGroupName) {
        this.instName = instName;
        this.type = type;
        this.powerGroupName = powerGroupName;
        this.contextSwitchTime = "0.0";
        this.interfaces = "";
        this.active = true;
    }

    public ConfigProcessor(ConfigProcessor cfgProc, String instName) {
        this(instName, cfgProc.type, cfgProc.contextSwitchTime, cfgProc.interfaces, cfgProc.active, cfgProc.powerGroupName);
    }

    public String toString() {
        String act = "";
        if (!this.isActive()) {
            act = "Disable";
        }
        if (this.hasInterfaces()) {
            return String.valueOf(this.instName) + " " + act + " [ Processor: " + this.type + ", Power Domain: " + this.powerGroupName + ", Context Switch Time = " + this.contextSwitchTime + " us, Interfaces = " + this.interfaces + " ]";
        }
        return String.valueOf(this.instName) + " " + act + " [ Processor: " + this.type + ", Power Domain: " + this.powerGroupName + ", Context Switch Time = " + this.contextSwitchTime + " us ]";
    }

    public boolean hasInterfaces() {
        return this.interfaces.length() > 0;
    }

    public boolean equals(ConfigProcessor cp) {
        return this.instName.equals(cp.getInstanceName());
    }

    public boolean identical(ConfigProcessor cp) {
        return this.instName.equals(cp.getInstanceName()) && this.type.equals(cp.getType()) && this.contextSwitchTime.equals(cp.getContextSwitchTime()) && this.interfaces.equals(cp.getInterfaces()) && this.active == cp.isActive();
    }

    @Override
    public int compareTo(Object cp) {
        return this.getInstanceName().compareTo(((ConfigProcessor)cp).getInstanceName());
    }

    public void setInstanceName(String val) {
        this.instName = val;
    }

    public String getInstanceName() {
        return this.instName;
    }

    public void setType(String val) {
        this.type = val;
    }

    public String getType() {
        return this.type;
    }

    public void setActive(boolean val) {
        this.active = val;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setContextSwitchTime(String val) {
        this.contextSwitchTime = val;
    }

    public String getContextSwitchTime() {
        return this.contextSwitchTime;
    }

    public void setInterfaces(String val) {
        this.interfaces = val;
    }

    public String getInterfaces() {
        return this.interfaces;
    }

    public void setPowerGroupName(String val) {
        this.powerGroupName = val;
    }

    public String getPowerGroupName() {
        return this.powerGroupName;
    }

    public int computeInstanceNumber(Vector<ConfigProcessor> procList) {
        int n = 0;
        int i = 0;
        while (i < procList.size()) {
            if (procList.elementAt(i).getType().equals(this.getType())) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public Vector<ConfigProcessor> getActiveInstanceList(Vector<ConfigProcessor> procList) {
        Vector<ConfigProcessor> instList = new Vector<ConfigProcessor>();
        int i = 0;
        while (i < procList.size()) {
            if (procList.elementAt(i).getType().equals(this.getType()) && procList.elementAt(i).isActive()) {
                instList.add(procList.elementAt(i));
            }
            ++i;
        }
        return instList;
    }

    public static Vector<ConfigProcessor> getActiveInstanceList(Vector<ConfigProcessor> procList, String type) {
        Vector<ConfigProcessor> instList = new Vector<ConfigProcessor>();
        int i = 0;
        while (i < procList.size()) {
            if (procList.elementAt(i).getType().equals(type) && procList.elementAt(i).isActive()) {
                instList.add(procList.elementAt(i));
            }
            ++i;
        }
        return instList;
    }

    public static Vector<String> getAllInstanceNameList(Vector<ConfigProcessor> procList) {
        Vector<String> instList = new Vector<String>();
        int i = 0;
        while (i < procList.size()) {
            instList.add(procList.elementAt(i).getInstanceName());
            ++i;
        }
        return instList;
    }

    public static String createInstanceName(Vector<ConfigProcessor> procList, String prefix) {
        String instName = String.valueOf(prefix) + "0";
        Vector<String> allInstNameList = ConfigProcessor.getAllInstanceNameList(procList);
        int i = 0;
        while (i < allInstNameList.size()) {
            instName = String.valueOf(prefix) + i;
            if (!allInstNameList.elementAt(i).equalsIgnoreCase(instName)) {
                return instName;
            }
            ++i;
        }
        return String.valueOf(prefix) + allInstNameList.size();
    }
}

