/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.CSVParser;
import fortress.generation.CodeAnalyzer;
import fortress.generation.FortressGeneration;
import fortress.generation.KeywordArgument;
import fortress.generation.ReplaceKeyword;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressBenchModule;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressConnection;
import fortress.xml.FortressNodeModule;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressSchematic;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class DoWaveGeneration {
    String configuration;

    public DoWaveGeneration(String configuration) {
        this.configuration = configuration;
    }

    public void Generate(OutputStream console) throws Exception {
        PrintStream out = new PrintStream(console);
        out.print("Loading Configuration ... ");
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        out.println("done");
        Vector<ConfigApplication> activeAppList = conf.getActiveConfigApplicationSchematicNameList();
        Vector<FortressSchematic> appList = new Vector<FortressSchematic>();
        int i = 0;
        while (i < activeAppList.size()) {
            ConfigApplication ca = activeAppList.elementAt(i);
            out.print("Loading Application : " + ca.getFile() + " ... ");
            FortressSchematic fs = new FortressSchematic(ca.getFile());
            fs.loadFile(ca);
            appList.add(fs);
            out.println("done");
            ++i;
        }
        String csvPath = FortressEnv.getCSVFilePath(this.configuration);
        Vector<String> csvfileList = FortressEnv.getFileListWithoutExtension(csvPath, ".csv");
        int i2 = 0;
        while (i2 < csvfileList.size()) {
            String csvfile = String.valueOf(csvPath) + csvfileList.elementAt(i2) + ".csv";
            try {
                this.Generate(out, conf, appList, csvfile, String.valueOf(csvfileList.elementAt(i2)) + ".do");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
    }

    void Generate(PrintStream out, FortressConfiguration conf, Vector<FortressSchematic> appList, String csvfile, String waveFileName) throws Exception {
        out.print("Loading Preferences ... ");
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        out.println("done");
        CSVParser csv_parser = new CSVParser(csvfile);
        String destViewWaveFile = FortressEnv.getViewWaveScriptFile(this.configuration);
        String src = FortressEnv.getTemplateViewWaveScriptFile();
        if (!FortressEnv.FileCopy(new File(src), new File(destViewWaveFile))) {
            FortressException.messageError(out, "Wave Format Gen.", "Copy of " + src + " is not possible on " + destViewWaveFile + " !");
        } else {
            out.println("Script generation of Wave conversion (do file) : " + destViewWaveFile + " ... ");
        }
        String template_filename = FortressEnv.getTemplateDoWave();
        String generated_filename = String.valueOf(FortressEnv.getWaveFilePath(this.configuration)) + waveFileName;
        out.print("Running generation of Wave script (do file) : " + generated_filename + " ... ");
        ReplaceKeyword rk = new ReplaceKeyword(template_filename, generated_filename);
        String buf_wave_con = "";
        String buf_task_state = "";
        String buf_exe_mode = "";
        String buf_algo_state = "";
        String buf_hyperperiod = "";
        String buf_conf_manager = "";
        String buf_header = "";
        buf_header = FortressGeneration.createFortressHeaderForTCL(generated_filename, "Wave File for ModelSim");
        buf_header = String.valueOf(buf_header) + FortressEnv.EOL;
        buf_exe_mode = String.valueOf(buf_exe_mode) + "add wave -noupdate -format Literal -label Hyperperiod -radix ascii /SystemC/\\\\Reconfiguration_manager.Hyperperiod\\\\" + FortressEnv.EOL;
        buf_hyperperiod = String.valueOf(buf_hyperperiod) + buf_exe_mode;
        Vector<ConfigApplication> configAppList = conf.getConfigApplicationList();
        int i = 0;
        while (i < appList.size()) {
            FortressSchematic fs = appList.elementAt(i);
            String appPrefix = appList.size() == 1 ? "" : String.valueOf(fs.getApplicationName()) + "__";
            Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(configAppList, fs.getFileName());
            int app_repeat = instanceConfigAppList.size();
            int repeat = 0;
            while (repeat < app_repeat) {
                FortressConnection connection;
                ConfigApplication ca = instanceConfigAppList.elementAt(repeat);
                Vector<FortressNodeModule> nodeList = fs.getNodeModuleList();
                String iter = app_repeat == 1 ? "" : "_" + ca.getInstanceName();
                String iter_number = app_repeat == 1 ? "" : "_" + repeat;
                int j = 0;
                while (j < nodeList.size()) {
                    FortressNodeModule node = nodeList.elementAt(j);
                    String moduleName = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter;
                    String moduleNamePath = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter_number;
                    if (conf.isModuleModeSignalTrace() || node.isEnableExecutionModeSignalsTrace()) {
                        buf_exe_mode = String.valueOf(buf_exe_mode) + "add wave -noupdate -expand -group {Execution Mode} -format Literal -label " + moduleName + "_exec_mode -radix ascii /SystemC/\\\\" + moduleNamePath + ".execution_mode\\\\" + FortressEnv.EOL;
                    }
                    buf_task_state = String.valueOf(buf_task_state) + "add wave -noupdate -expand -group {Task state} -format Literal -label " + moduleName + "_status -radix ascii /SystemC/\\\\Reconfiguration_manager." + moduleNamePath + "_status\\\\" + FortressEnv.EOL;
                    if (conf.getGenerateCommunicationsInCSV()) {
                        Vector<FortressConnection> outConnection = node.getOutConnections();
                        if (outConnection.size() > 0) {
                            buf_wave_con = String.valueOf(buf_wave_con) + "# " + moduleName + " Output(s)" + FortressEnv.EOL;
                        }
                        int k = 0;
                        while (k < outConnection.size()) {
                            FortressConnection connection2 = outConnection.elementAt(k);
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection2.getConnectionName() + "} -format Literal -label Address -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".address_out_" + k + "\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection2.getConnectionName() + "} -format Literal -label Data -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".data_out_" + k + "\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection2.getConnectionName() + "} -format Literal -label Phase -radix ascii /SystemC/\\\\" + moduleNamePath + ".initiator_" + k + ".phase\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection2.getConnectionName() + "} -format Literal -label {Commmunication status} -radix ascii /SystemC/\\\\" + moduleNamePath + ".communication_" + k + "\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + FortressEnv.EOL;
                            ++k;
                        }
                        Vector<FortressConnection> inConnection = node.getInConnections();
                        if (inConnection.size() > 0) {
                            buf_wave_con = String.valueOf(buf_wave_con) + "# " + moduleName + " Input(s)" + FortressEnv.EOL;
                        }
                        int k2 = 0;
                        while (k2 < inConnection.size()) {
                            connection = inConnection.elementAt(k2);
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection.getConnectionName() + "} -format Literal -label Address -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".address_in_" + k2 + "\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection.getConnectionName() + "} -format Literal -label Data -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".data_in_" + k2 + "\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection.getConnectionName() + "} -format Literal -label Phase -radix ascii /SystemC/\\\\" + moduleNamePath + ".target_" + k2 + ".phase\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + FortressEnv.EOL;
                            ++k2;
                        }
                    }
                    ++j;
                }
                Vector<FortressBenchModule> testbenchList = fs.getTestbenchList();
                int j2 = 0;
                while (j2 < testbenchList.size()) {
                    FortressBenchModule node = testbenchList.elementAt(j2);
                    String moduleName = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter;
                    String moduleNamePath = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter_number;
                    if (conf.getGenerateCommunicationsInCSV()) {
                        Vector<FortressConnection> outConnection = node.getOutConnections();
                        if (outConnection.size() > 0) {
                            buf_wave_con = String.valueOf(buf_wave_con) + "# " + moduleName + " Output(s)" + FortressEnv.EOL;
                        }
                        int k = 0;
                        while (k < outConnection.size()) {
                            connection = outConnection.elementAt(k);
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection.getConnectionName() + "} -format Literal -label Phase -radix ascii /SystemC/\\\\" + moduleNamePath + ".initiator_" + k + ".phase\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection.getConnectionName() + "}   -format Literal -label Command -radix ascii /SystemC/\\\\" + moduleNamePath + ".initiator_" + k + ".transaction.command\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection.getConnectionName() + "}   -format Literal -label Address -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".initiator_" + k + ".transaction.address\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection.getConnectionName() + "}   -format Literal -label Data -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".initiator_" + k + ".transaction.data\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + FortressEnv.EOL;
                            ++k;
                        }
                        Vector<FortressConnection> inConnection = node.getInConnections();
                        if (inConnection.size() > 0) {
                            buf_wave_con = String.valueOf(buf_wave_con) + "# " + moduleName + " Input(s)" + FortressEnv.EOL;
                        }
                        int k3 = 0;
                        while (k3 < inConnection.size()) {
                            FortressConnection connection3 = inConnection.elementAt(k3);
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "} -expand -group {" + connection3.getConnectionName() + "} -format Literal -label Phase -radix ascii /SystemC/\\\\" + moduleNamePath + ".target_" + k3 + ".phase\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection3.getConnectionName() + "}  -format Literal -label Command -radix ascii /SystemC/\\\\" + moduleNamePath + ".target_" + k3 + ".transaction.command\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection3.getConnectionName() + "}  -format Literal -label Address -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".target_" + k3 + ".transaction.address\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + "add wave -noupdate -expand -group {" + moduleName + "}  -group {" + connection3.getConnectionName() + "}  -format Literal -label Data -radix hexadecimal /SystemC/\\\\" + moduleNamePath + ".target_" + k3 + ".transaction.data\\\\" + FortressEnv.EOL;
                            buf_wave_con = String.valueOf(buf_wave_con) + FortressEnv.EOL;
                            ++k3;
                        }
                    }
                    ++j2;
                }
                ++repeat;
            }
            ++i;
        }
        String buf_sw_loader_state = "";
        String buf_scheduler_state = "";
        if (conf.isDebugTrace()) {
            buf_scheduler_state = String.valueOf(buf_scheduler_state) + "# Manager Configuration Signal Trace (Optional) : Scheduler state" + FortressEnv.EOL;
            buf_scheduler_state = String.valueOf(buf_scheduler_state) + "add wave -noupdate -expand -group Manager -expand -group {Scheduler state} -format Literal -label NbCallsScheduler -radix unsigned /SystemC/\\\\Reconfiguration_manager.NbCallsScheduler\\\\" + FortressEnv.EOL;
        }
        String buf_fpga_state = "";
        if (conf.getGenerateAnalogSignalsInCSV() && conf.isDebugTrace()) {
            buf_fpga_state = String.valueOf(buf_fpga_state) + "# Manager Configuration Signal Trace (Optional) : FPGA state" + FortressEnv.EOL;
            buf_fpga_state = String.valueOf(buf_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {FPGA state} -format Analog-Step -height 74 -max 100.0 -label FPGA_Processor_utilization /SystemC/\\\\Reconfiguration_manager.FPGA_Processor_utilization\\\\" + FortressEnv.EOL;
            buf_fpga_state = String.valueOf(buf_fpga_state) + FortressEnv.EOL;
        }
        String buf_icap_state = "";
        String buf_analog_fpga_state = "";
        if (csv_parser.getRZNumber() > 0) {
            buf_icap_state = String.valueOf(buf_icap_state) + "# Hw Ressource Utilization " + FortressEnv.EOL;
            int i2 = 0;
            while (i2 < conf.getHwReconfigurationUnits()) {
                buf_icap_state = String.valueOf(buf_icap_state) + "add wave -noupdate -expand -group Manager -expand -group {Hw reconfiguration unit " + i2 + " state} -format Literal -label HW_reconfiguration_unit -radix ascii /SystemC/\\\\Reconfiguration_manager.HW_reconfiguration_unit_" + i2 + "\\\\" + FortressEnv.EOL;
                if (conf.getGenerateAnalogSignalsInCSV()) {
                    buf_icap_state = String.valueOf(buf_icap_state) + "add wave -noupdate -expand -group Manager -expand -group {Hw reconfiguration unit " + i2 + " state} -format Analog-Step -height 74 -max 100.0 -label HW_reconfiguration_unit_occupation_rate /SystemC/\\\\Reconfiguration_manager.HW_reconfiguration_unit_" + i2 + "_occupation_rate\\\\" + FortressEnv.EOL;
                }
                ++i2;
            }
            Vector<String> ressourceList = csv_parser.getRessourceList();
            int i3 = 0;
            while (i3 < ressourceList.size()) {
                String ressourceName = ressourceList.elementAt(i3);
                if (conf.getGenerateAnalogSignalsInCSV()) {
                    buf_icap_state = String.valueOf(buf_icap_state) + "add wave -noupdate -expand -group Manager -expand -group {FPGA state} -format Analog-Step -height 74 -max 100.0 -label FPGA_" + ressourceName + "_utilization /SystemC/\\\\Reconfiguration_manager.FPGA_" + ressourceName + "_utilization\\\\" + FortressEnv.EOL;
                }
                ++i3;
            }
            buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "# RZ Ressource Utilization " + FortressEnv.EOL;
            Vector<String> rzNameList = csv_parser.getRZList();
            int i4 = 0;
            while (i4 < rzNameList.size()) {
                String rzName = rzNameList.elementAt(i4);
                buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Literal -radix ascii -label " + rzName + " /SystemC/\\\\Reconfiguration_manager." + rzName + "\\\\" + FortressEnv.EOL;
                if (conf.getGenerateAnalogSignalsInCSV()) {
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_occupation_rate /SystemC/\\\\Reconfiguration_manager." + rzName + "_occupation_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_running_rate /SystemC/\\\\Reconfiguration_manager." + rzName + "_running_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_mapped_rate /SystemC/\\\\Reconfiguration_manager." + rzName + "_mapped_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_config_rate /SystemC/\\\\Reconfiguration_manager." + rzName + "_config_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_blank_rate /SystemC/\\\\Reconfiguration_manager." + rzName + "_blank_rate\\\\" + FortressEnv.EOL;
                    int j = 0;
                    while (j < ressourceList.size()) {
                        String ressourceName = ressourceList.elementAt(j);
                        buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {RZ state} -expand -group {" + rzName + "} -format Analog-Step -height 74 -max 100.0 -label " + rzName + "_" + ressourceName + "_utilization /SystemC/\\\\Reconfiguration_manager." + rzName + "_" + ressourceName + "_utilization\\\\" + FortressEnv.EOL;
                        ++j;
                    }
                }
                ++i4;
            }
        }
        if (csv_parser.getProcessorNumber() > 0) {
            buf_icap_state = String.valueOf(buf_icap_state) + "# Sw Ressource Utilization " + FortressEnv.EOL;
            int i5 = 0;
            while (i5 < conf.getSwReconfigurationUnits()) {
                buf_icap_state = String.valueOf(buf_icap_state) + "add wave -noupdate -expand -group Manager -expand -group {Sw reconfiguration unit state} -format Literal -label SW_reconfiguration_unit -radix ascii /SystemC/\\\\Reconfiguration_manager.SW_reconfiguration_unit_" + i5 + "\\\\" + FortressEnv.EOL;
                if (conf.getGenerateAnalogSignalsInCSV()) {
                    buf_icap_state = String.valueOf(buf_icap_state) + "add wave -noupdate -expand -group Manager -expand -group {Sw reconfiguration unit state} -format Analog-Step -height 74 -max 100.0 -label SW_reconfiguration_unit_occupation_rate /SystemC/\\\\Reconfiguration_manager.SW_reconfiguration_unit_" + i5 + "_occupation_rate\\\\" + FortressEnv.EOL;
                }
                ++i5;
            }
            buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "# Processor Ressource Utilization " + FortressEnv.EOL;
            Vector<String> procNameList = csv_parser.getProcessorList();
            int i6 = 0;
            while (i6 < procNameList.size()) {
                String procName = procNameList.elementAt(i6);
                buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Literal -radix ascii -label " + procName + " /SystemC/\\\\Reconfiguration_manager." + procName + "\\\\" + FortressEnv.EOL;
                if (conf.getGenerateAnalogSignalsInCSV()) {
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Analog-Step -height 74 -max 100.0 -label " + procName + "_occupation_rate /SystemC/\\\\Reconfiguration_manager." + procName + "_occupation_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Analog-Step -height 74 -max 100.0 -label " + procName + "_running_rate /SystemC/\\\\Reconfiguration_manager." + procName + "_running_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Analog-Step -height 74 -max 100.0 -label " + procName + "_mapped_rate /SystemC/\\\\Reconfiguration_manager." + procName + "_mapped_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Analog-Step -height 74 -max 100.0 -label " + procName + "_config_rate /SystemC/\\\\Reconfiguration_manager." + procName + "_config_rate\\\\" + FortressEnv.EOL;
                    buf_analog_fpga_state = String.valueOf(buf_analog_fpga_state) + "add wave -noupdate -expand -group Manager -expand -group {Processor state} -expand -group {" + procName + "} -format Analog-Step -height 74 -max 100.0 -label " + procName + "_blank_rate /SystemC/\\\\Reconfiguration_manager." + procName + "_blank_rate\\\\" + FortressEnv.EOL;
                }
                ++i6;
            }
        }
        String buf_monitoring = "";
        CodeAnalyzer codeAnalyzer = new CodeAnalyzer();
        codeAnalyzer.AddMonitoringKeywords();
        Vector<KeywordArgument> list = codeAnalyzer.parse(FortressEnv.getUserMonitoringModuleFile(), true);
        Vector<String> monitoring_module_list = pref.getMonitoringModuleList();
        int i7 = 0;
        while (i7 < monitoring_module_list.size()) {
            String monitoring_name = monitoring_module_list.elementAt(i7);
            Vector<KeywordArgument> argList = codeAnalyzer.extractSignalNameForMonitoringModule(list, monitoring_name);
            if (argList.size() > 0) {
                int j = 0;
                while (j < argList.size()) {
                    KeywordArgument ka = argList.elementAt(j);
                    String arg1 = ka.getArgument(1);
                    arg1 = arg1.substring(1, arg1.length() - 1).replace(" ", "_");
                    buf_monitoring = ka.isMonitoringAnalogTrace() ? String.valueOf(buf_monitoring) + "add wave -noupdate -expand -group {" + monitoring_name + "} -format Analog-Step -height " + ka.getArgument(4) + " -min " + ka.getArgument(2) + " -max " + ka.getArgument(3) + " -label " + arg1 + " /SystemC/\\\\" + monitoring_name + "." + arg1 + "\\\\" + FortressEnv.EOL : String.valueOf(buf_monitoring) + "add wave -noupdate -expand -group {" + monitoring_name + "} -format Literal " + " -radix " + ka.getArgument(2) + " -label " + arg1 + " /SystemC/\\\\" + monitoring_name + "." + arg1 + "\\\\" + FortressEnv.EOL;
                    ++j;
                }
            } else {
                out.print("Warning : No Signal trace found in Monitoring File for " + monitoring_name + " module !");
            }
            ++i7;
        }
        rk.addReplaceKeyword("FORTRESS_HEADER", buf_header);
        rk.addReplaceKeyword("FORTRESS_ADD_WAVE_CONNECTIONS", buf_wave_con);
        rk.addReplaceKeyword("FORTRESS_ALGORITHM_STATE", buf_algo_state);
        rk.addReplaceKeyword("FORTRESS_ADD_EXECUTION_MODE", buf_exe_mode);
        rk.addReplaceKeyword("FORTRESS_HYPERPERIOD", buf_hyperperiod);
        rk.addReplaceKeyword("FORTRESS_ADD_TASK_STATE", buf_task_state);
        rk.addReplaceKeyword("FORTRESS_SOFTWARE_LOADER_STATE", buf_sw_loader_state);
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_STATE", buf_scheduler_state);
        rk.addReplaceKeyword("FORTRESS_FPGA_STATE", buf_fpga_state);
        rk.addReplaceKeyword("FORTRESS_CONFIGURATION_MANAGER", buf_conf_manager);
        rk.addReplaceKeyword("FORTRESS_ICAP_STATE", buf_icap_state);
        rk.addReplaceKeyword("FORTRESS_MONITORING", buf_monitoring);
        rk.addReplaceKeyword("FORTRESS_ANALOG_FPGA_STATE", buf_analog_fpga_state);
        String buf = String.valueOf(csv_parser.getApplicationOffsetInUs());
        rk.addReplaceKeyword("FORTRESS_WAVERESTORECURCORS", buf);
        buf = String.valueOf(csv_parser.getApplicationOffsetInUs() + csv_parser.getApplicationHyperperiodInUs());
        rk.addReplaceKeyword("FORTRESS_WAVERESTOREZOOM", buf);
        rk.Generate();
        out.println("done");
        String buf_modelsim_path = "";
        if (FortressEnv.isWindowsOS()) {
            template_filename = FortressEnv.getWindowsTemplateViewWaveBatFile();
            generated_filename = FortressEnv.getWindowsViewWaveBatFile(this.configuration);
            out.print("Running generation of Wave Bat file : " + generated_filename + " ... ");
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf_header = "";
            buf_header = String.valueOf(buf_header) + FortressGeneration.createFortressHeaderForBatFile(generated_filename, "Wave File for ModelSim");
            buf_modelsim_path = "\"" + pref.getModelsimPath() + "\"";
            rk.addReplaceKeyword("FORTRESS_HEADER", buf_header);
            rk.addReplaceKeyword("FORTRESS_MODELSIM_PATH", buf_modelsim_path);
            rk.Generate();
            out.println("done");
        }
        if (FortressEnv.isLinuxOS()) {
            template_filename = FortressEnv.getLinuxTemplateViewWaveScriptFile();
            generated_filename = FortressEnv.getLinuxViewWaveScriptFile(this.configuration);
            out.print("Running generation of Linux Wave Script file : " + generated_filename + " ... ");
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf_modelsim_path = "";
            buf_header = "";
            buf_header = String.valueOf(buf_header) + FortressGeneration.createFortressHeaderForTCL(generated_filename, "Wave File Script for ModelSim (Linux version)");
            buf_modelsim_path = "\"" + pref.getModelsimPath() + "\"";
            rk.addReplaceKeyword("FORTRESS_HEADER", buf_header);
            rk.addReplaceKeyword("FORTRESS_MODELSIM_PATH", buf_modelsim_path);
            rk.Generate(true);
            out.println("done");
        }
    }
}

