/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.generation.KeywordArgument;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class CodeAnalyzer {
    Vector<String> keywordList = new Vector();

    public void addKeyword(String kw) {
        this.keywordList.add(kw);
    }

    public void AddMonitoringKeywords() {
        this.keywordList.add("MONITORING_MODULE");
        this.keywordList.add("MONITORING_ANALOG_TRACE");
        this.keywordList.add("MONITORING_TRACE");
    }

    public Vector<KeywordArgument> parse(String filename, boolean removeWithoutArg) throws IOException {
        Vector<KeywordArgument> list = new Vector<KeywordArgument>();
        boolean comment_area = false;
        try {
            String read_line;
            FileInputStream ips = new FileInputStream(filename);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((read_line = br.readLine()) != null) {
                Vector<String> arg;
                int commentIndexStart = read_line.indexOf("/*");
                int commentIndexStop = read_line.indexOf("*/");
                if (commentIndexStart != -1 && !comment_area) {
                    comment_area = true;
                    read_line = commentIndexStop == -1 ? read_line.substring(commentIndexStart) : (commentIndexStop > commentIndexStart ? String.valueOf(read_line.substring(0, commentIndexStart)) + read_line.substring(commentIndexStop + 1) : read_line.substring(commentIndexStart));
                } else if (commentIndexStop != -1 && comment_area) {
                    comment_area = false;
                    read_line = read_line.substring(commentIndexStop + 1);
                }
                if (comment_area) {
                    read_line = "";
                } else {
                    int commentLineIndexStart = read_line.indexOf("//");
                    if (commentLineIndexStart != -1 && !comment_area) {
                        read_line = read_line.substring(0, commentLineIndexStart);
                    }
                }
                int index = this.searchKeyword(read_line);
                if (index == -1 || (arg = this.getArguments(this.keywordList.elementAt(index), read_line)).size() <= 0 && removeWithoutArg) continue;
                list.add(new KeywordArgument(this.keywordList.elementAt(index), arg));
            }
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return list;
    }

    public String toString(Vector<KeywordArgument> list) {
        String s = "";
        int i = 0;
        while (i < list.size()) {
            s = String.valueOf(s) + list.elementAt(i).toString() + FortressEnv.EOL;
            ++i;
        }
        return s;
    }

    protected int searchKeyword(String line) {
        int i = 0;
        while (i < this.keywordList.size()) {
            if (line.contains(this.keywordList.elementAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Vector<String> getArguments(String keyword, String line) {
        Vector<String> arg = new Vector<String>();
        int index = line.indexOf(keyword);
        int indexStart = line.indexOf("(", index);
        int indexEnd = line.indexOf(")", index);
        if (indexStart == -1 || indexEnd == -1) {
            return arg;
        }
        String argString = line.substring(indexStart + 1, indexEnd);
        String[] argList = argString.split(",");
        int i = 0;
        while (i < argList.length) {
            arg.add(argList[i].trim());
            ++i;
        }
        return arg;
    }

    public Vector<KeywordArgument> extractSignalNameForMonitoringModule(Vector<KeywordArgument> list, String monitoringModuleName) {
        Vector<KeywordArgument> sigList = new Vector<KeywordArgument>();
        int startIndex = this.searchIndexForMonitoringModule(list, monitoringModuleName);
        if (startIndex == -1) {
            return sigList;
        }
        int i = startIndex;
        while (i < list.size()) {
            KeywordArgument ka = list.elementAt(i);
            if (ka.isMonitoringTrace() || ka.isMonitoringAnalogTrace()) {
                sigList.add(ka);
            }
            ++i;
        }
        return sigList;
    }

    public int searchIndexForMonitoringModule(Vector<KeywordArgument> list, String monitoringModuleName) {
        int i = 0;
        while (i < list.size()) {
            KeywordArgument ka = list.elementAt(i);
            if (ka == null) {
                return -1;
            }
            if (ka.foundArgument("MONITORING_MODULE", monitoringModuleName) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

