/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import java.io.OutputStream;
import java.io.PrintStream;

public class FortressException
extends Exception {
    public static final String DEVICE_HEADER_GENERATION = "Device Header Gen.";
    public static final String APP_GENERATION = "Application Gen.";
    public static final String DO_WAVE_GENERATION = "Wave Format Gen.";
    public static final String SUMMARY_REPORT_GENERATION = "Summary Report Gen.";
    public static final String STAT_REPORT_GENERATION = "Statictic Report Gen.";
    public static final String VARIOUS_GENERATION = "Various Gen.";
    public static final String CHECK_ENV_SIMULATION = "Env Sim.";
    String action;

    public FortressException(String action, String message) {
        super(message);
        this.action = action;
    }

    @Override
    public String toString() {
        return FortressException.createErrorMessage(this.action, this.getMessage());
    }

    public static String createErrorMessage(String action, String message) {
        return "ERROR (" + action + "): " + message;
    }

    public static String createWarningMessage(String action, String message) {
        return "WARNING (" + action + "): " + message;
    }

    public static String createInfoMessage(String action, String message) {
        return "INFO (" + action + "): " + message;
    }

    public static void messageInfo(OutputStream console, String action, String mess) {
        PrintStream out = new PrintStream(console);
        out.println(FortressException.createInfoMessage(action, mess));
    }

    public static void messageWarning(OutputStream console, String action, String mess) {
        PrintStream out = new PrintStream(console);
        out.println(FortressException.createWarningMessage(action, mess));
    }

    public static void messageError(OutputStream console, String action, String mess) throws FortressException {
        PrintStream out = new PrintStream(console);
        out.println(FortressException.createErrorMessage(action, mess));
        throw new FortressException(action, mess);
    }

    public static void messageInfo(PrintStream console, String action, String mess) {
        console.println(FortressException.createInfoMessage(action, mess));
    }

    public static void messageWarning(PrintStream console, String action, String mess) {
        console.println(FortressException.createWarningMessage(action, mess));
    }

    public static void messageError(PrintStream console, String action, String mess) throws FortressException {
        console.println(FortressException.createErrorMessage(action, mess));
        throw new FortressException(action, mess);
    }
}

