/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import Modulesystem.diagram.commands.PowerGroupInputDialog;
import Modulesystem.diagram.commands.ProcessorInputDialog;
import fortress.env.FortressEnv;
import fortress.xml.ConfigPowerGroup;
import fortress.xml.ConfigProcessor;
import fortress.xml.ConfigProcessorName;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.JDOMException;

public class ProcessorParametersTab
implements ActionListener,
ItemListener {
    JFrame WindowsParameters;
    JTabbedPane Tab;
    DefaultListModel<ConfigProcessor> Model_Processor_list = null;
    JList<ConfigProcessor> Processor_list = null;
    FortressPreferences pref = null;
    FortressConfiguration config = null;
    JButton ADD_Processor = null;
    JButton Remove_Processor = null;
    JButton Duplicate_Processor = null;
    JComboBox<String> inst_groupNameComboBox;
    JComboBox<String> inst_processorNameComboBox;
    JLabel instName_label = null;
    JTextField instName = null;
    JCheckBox Active_proc = null;
    JLabel Context_switch_time_label = null;
    JFormattedTextField Context_switch_time = null;
    JLabel Context_switch_time_unit_label = null;
    JLabel Interfaces_label = null;
    JFormattedTextField Interfaces = null;
    JLabel Interfaces_unit_example = null;
    int selectedProcIndex;
    JButton ADD_RZGroup;
    JButton Edit_RZGroup;
    JButton Remove_RZGroup;
    JButton Duplicate_RZGroup;
    JComboBox<ConfigPowerGroup> rz_groupNameComboBox;
    JComboBox<String> rz_default_groupNameComboBox;
    JButton ADD_Group;
    JButton Edit_Group;
    JButton Remove_Group;
    JButton Duplicate_Group;
    JButton ADD_ProcessorName;
    JButton Edit_ProcessorName;
    JButton Remove_ProcessorName;
    JComboBox<ConfigPowerGroup> groupNameComboBox;
    JComboBox<ConfigProcessorName> processorNameComboBox;

    public ProcessorParametersTab(JFrame Windows, JTabbedPane Tab, FortressPreferences pref, FortressConfiguration config) {
        this.WindowsParameters = Windows;
        this.Tab = Tab;
        this.pref = pref;
        this.config = config;
        this.Model_Processor_list = new DefaultListModel();
        this.Processor_list = new JList<ConfigProcessor>(this.Model_Processor_list);
        this.ADD_Processor = new JButton("Add");
        this.ADD_Processor.setPreferredSize(new Dimension(90, 20));
        this.Remove_Processor = new JButton("Remove");
        this.Remove_Processor.setPreferredSize(new Dimension(90, 20));
        this.Duplicate_Processor = new JButton("Duplicate");
        this.Duplicate_Processor.setPreferredSize(new Dimension(90, 20));
        this.inst_groupNameComboBox = new JComboBox();
        this.inst_groupNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.inst_groupNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    String name = (String)ProcessorParametersTab.this.inst_groupNameComboBox.getSelectedItem();
                    if (name == null) {
                        name = "Default";
                    }
                    configProc.setPowerGroupName(name);
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        });
        this.inst_processorNameComboBox = new JComboBox();
        this.inst_processorNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.inst_processorNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    String name = (String)ProcessorParametersTab.this.inst_processorNameComboBox.getSelectedItem();
                    if (name == null) {
                        name = "";
                    }
                    configProc.setType(name);
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        });
        this.instName_label = new JLabel("Instance Name: ");
        this.instName = new JTextField();
        this.instName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    String name = ProcessorParametersTab.this.instName.getText().trim();
                    configProc.setInstanceName(name);
                    ProcessorParametersTab.this.instName.setText(name);
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        });
        this.Active_proc = new JCheckBox("Active  ");
        this.Context_switch_time_label = new JLabel("Context Swith Time: ");
        this.Context_switch_time = new JFormattedTextField((Object)"10.0"){

            @Override
            public void commitEdit() throws ParseException {
                super.commitEdit();
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    configProc.setContextSwitchTime(ProcessorParametersTab.this.Context_switch_time.getValue().toString());
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        };
        this.Context_switch_time_unit_label = new JLabel(" us  ");
        this.Interfaces_label = new JLabel("Interfaces : ");
        this.Interfaces = new JFormattedTextField((Object)""){

            @Override
            public void commitEdit() throws ParseException {
                super.commitEdit();
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    configProc.setInterfaces(ProcessorParametersTab.this.Interfaces.getValue().toString());
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        };
        this.Interfaces_unit_example = new JLabel("(Ex: AXI & PLB)");
        this.Processor_list.setCellRenderer(new AppListRenderer());
        this.instName.setPreferredSize(new Dimension(150, 20));
        this.instName.setToolTipText("Instance Name of the Application");
        this.instName_label.setToolTipText("Instance Name of the Application");
        this.Active_proc.setToolTipText("Active the processor");
        this.Active_proc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                    configProc.setActive(ProcessorParametersTab.this.Active_proc.isSelected());
                    ProcessorParametersTab.this.Model_Processor_list.set(ProcessorParametersTab.this.selectedProcIndex, configProc);
                }
            }
        });
        this.Context_switch_time.setPreferredSize(new Dimension(50, 20));
        this.Context_switch_time.setToolTipText("Context swith time in us");
        this.Context_switch_time_label.setToolTipText("Context swith time in us");
        this.Interfaces.setPreferredSize(new Dimension(200, 20));
        this.Interfaces.setToolTipText("Supported interfaces on processor");
        this.Interfaces_label.setToolTipText("Supported interfaces on processor");
        this.processorNameComboBox = new JComboBox();
        this.rz_default_groupNameComboBox = new JComboBox();
        this.rz_groupNameComboBox = new JComboBox();
        this.groupNameComboBox = new JComboBox();
        this.selectedProcIndex = -1;
    }

    protected void loadConfigProcessorField(ConfigProcessor ca) {
        this.instName.setText(ca.getInstanceName());
        this.Active_proc.setSelected(ca.isActive());
        this.Context_switch_time.setValue(ca.getContextSwitchTime());
        this.Interfaces.setValue(ca.getInterfaces());
    }

    protected void saveConfigProcessorField(ConfigProcessor ca) {
        ca.setInstanceName(this.instName.getText());
        ca.setActive(this.Active_proc.isSelected());
        ca.setContextSwitchTime(this.Context_switch_time.getValue().toString());
        ca.setInterfaces(this.Interfaces.getValue().toString());
    }

    public void CreateProcessorParametersTab() {
        JPanel rz_group_panel = new JPanel();
        FlowLayout fl = new FlowLayout(0);
        fl.setHgap(5);
        rz_group_panel.setLayout(fl);
        rz_group_panel.setBorder(BorderFactory.createTitledBorder("Volt/Freq RZ Domain"));
        this.ADD_RZGroup = new JButton("Add");
        this.ADD_RZGroup.setPreferredSize(new Dimension(90, 20));
        this.ADD_RZGroup.addActionListener(this);
        this.Edit_RZGroup = new JButton("Edit");
        this.Edit_RZGroup.setPreferredSize(new Dimension(90, 20));
        this.Edit_RZGroup.addActionListener(this);
        this.Remove_RZGroup = new JButton("Remove");
        this.Remove_RZGroup.setPreferredSize(new Dimension(90, 20));
        this.Remove_RZGroup.addActionListener(this);
        this.Duplicate_RZGroup = new JButton("Duplicate");
        this.Duplicate_RZGroup.setPreferredSize(new Dimension(90, 20));
        this.Duplicate_RZGroup.addActionListener(this);
        this.rz_groupNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.rz_groupNameComboBox.addItemListener(this);
        this.rz_default_groupNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.rz_default_groupNameComboBox.addItemListener(this);
        rz_group_panel.add(this.rz_groupNameComboBox);
        rz_group_panel.add(this.ADD_RZGroup);
        rz_group_panel.add(this.Edit_RZGroup);
        rz_group_panel.add(this.Remove_RZGroup);
        rz_group_panel.add(this.Duplicate_RZGroup);
        rz_group_panel.add(new JLabel("Used Domain: "));
        rz_group_panel.add(this.rz_default_groupNameComboBox);
        JPanel group_panel = new JPanel();
        fl = new FlowLayout(0);
        fl.setHgap(5);
        group_panel.setLayout(fl);
        group_panel.setBorder(BorderFactory.createTitledBorder("Volt/Freq Processor Domain"));
        this.ADD_Group = new JButton("Add");
        this.ADD_Group.setPreferredSize(new Dimension(90, 20));
        this.ADD_Group.addActionListener(this);
        this.Edit_Group = new JButton("Edit");
        this.Edit_Group.setPreferredSize(new Dimension(90, 20));
        this.Edit_Group.addActionListener(this);
        this.Remove_Group = new JButton("Remove");
        this.Remove_Group.setPreferredSize(new Dimension(90, 20));
        this.Remove_Group.addActionListener(this);
        this.Duplicate_Group = new JButton("Duplicate");
        this.Duplicate_Group.setPreferredSize(new Dimension(90, 20));
        this.Duplicate_Group.addActionListener(this);
        this.groupNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.groupNameComboBox.addItemListener(this);
        group_panel.add(this.groupNameComboBox);
        group_panel.add(this.ADD_Group);
        group_panel.add(this.Edit_Group);
        group_panel.add(this.Remove_Group);
        group_panel.add(this.Duplicate_Group);
        JPanel processor_panel = new JPanel();
        fl = new FlowLayout(0);
        fl.setHgap(5);
        processor_panel.setLayout(fl);
        processor_panel.setBorder(BorderFactory.createTitledBorder("Processor"));
        this.ADD_ProcessorName = new JButton("Add");
        this.ADD_ProcessorName.setPreferredSize(new Dimension(90, 20));
        this.ADD_ProcessorName.addActionListener(this);
        this.Edit_ProcessorName = new JButton("Edit");
        this.Edit_ProcessorName.setPreferredSize(new Dimension(90, 20));
        this.Edit_ProcessorName.addActionListener(this);
        this.Remove_ProcessorName = new JButton("Remove");
        this.Remove_ProcessorName.setPreferredSize(new Dimension(90, 20));
        this.Remove_ProcessorName.addActionListener(this);
        this.processorNameComboBox.setPreferredSize(new Dimension(190, 20));
        this.processorNameComboBox.addItemListener(this);
        processor_panel.add(this.processorNameComboBox);
        processor_panel.add(this.ADD_ProcessorName);
        processor_panel.add(this.Edit_ProcessorName);
        processor_panel.add(this.Remove_ProcessorName);
        JPanel p_instance_Button = new JPanel();
        fl = new FlowLayout(2);
        fl.setHgap(10);
        p_instance_Button.setLayout(fl);
        p_instance_Button.add(this.ADD_Processor);
        p_instance_Button.add(this.Remove_Processor);
        p_instance_Button.add(this.Duplicate_Processor);
        JLabel proc_instance_list_Label = new JLabel("Processor Instances");
        JScrollPane proc_instance_list_scroller = new JScrollPane(this.Processor_list);
        proc_instance_list_scroller.setPreferredSize(new Dimension(760, 200));
        JPanel p_proc_instance_list = new JPanel();
        GroupLayout g_Processor_list = new GroupLayout(p_proc_instance_list);
        p_proc_instance_list.setLayout(g_Processor_list);
        g_Processor_list.setHorizontalGroup(g_Processor_list.createParallelGroup().addComponent(proc_instance_list_Label).addComponent(proc_instance_list_scroller));
        g_Processor_list.setVerticalGroup(g_Processor_list.createSequentialGroup().addComponent(proc_instance_list_Label).addGap(10).addComponent(proc_instance_list_scroller));
        JPanel p_proc_instance_attribute_list1 = new JPanel();
        p_proc_instance_attribute_list1.setLayout(new FlowLayout(0));
        p_proc_instance_attribute_list1.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        p_proc_instance_attribute_list1.add(this.instName_label);
        p_proc_instance_attribute_list1.add(this.instName);
        p_proc_instance_attribute_list1.add(new JLabel("Processor: "));
        p_proc_instance_attribute_list1.add(this.inst_processorNameComboBox);
        p_proc_instance_attribute_list1.add(new JLabel("Power Group: "));
        p_proc_instance_attribute_list1.add(this.inst_groupNameComboBox);
        JPanel p_proc_instance_attribute_list2 = new JPanel();
        p_proc_instance_attribute_list2.setLayout(new FlowLayout(0));
        p_proc_instance_attribute_list2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        p_proc_instance_attribute_list2.add(this.Active_proc);
        p_proc_instance_attribute_list2.add(this.Context_switch_time_label);
        p_proc_instance_attribute_list2.add(this.Context_switch_time);
        p_proc_instance_attribute_list2.add(this.Context_switch_time_unit_label);
        p_proc_instance_attribute_list2.add(this.Interfaces_label);
        p_proc_instance_attribute_list2.add(this.Interfaces);
        p_proc_instance_attribute_list2.add(this.Interfaces_unit_example);
        JPanel P_ProcessorParameters = new JPanel();
        P_ProcessorParameters.setLayout(new GridBagLayout());
        GridBagConstraints constraintLayout = new GridBagConstraints();
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 0;
        JPanel page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(rz_group_panel);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 1;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(group_panel);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 2;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(processor_panel);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 3;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(p_proc_instance_list);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 4;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(p_instance_Button);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 5;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(p_proc_instance_attribute_list1);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 6;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(p_proc_instance_attribute_list2);
        P_ProcessorParameters.add((Component)page_info_panel, constraintLayout);
        JScrollPane ScrollPane_ProcessorParameters = new JScrollPane(P_ProcessorParameters);
        this.Tab.insertTab("Processor Parameters", null, ScrollPane_ProcessorParameters, null, 2);
        this.Processor_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (arg0.getValueIsAdjusting()) {
                    return;
                }
                if (ProcessorParametersTab.this.Model_Processor_list.isEmpty()) {
                    ProcessorParametersTab.this.selectedProcIndex = -1;
                } else {
                    ConfigProcessor configProc;
                    try {
                        if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                            configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                            String oldInstName = configProc.getInstanceName();
                            String newName = ProcessorParametersTab.this.instName.getText();
                            if (ProcessorParametersTab.this.config.existsConfigProcessorInstanceName(newName) && !oldInstName.equals(newName)) {
                                ProcessorParametersTab.this.instName.setText(oldInstName);
                                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                            }
                            ProcessorParametersTab.this.saveConfigProcessorField(configProc);
                            ProcessorParametersTab.this.config.updateConfigProcessor(oldInstName, configProc);
                        }
                    }
                    catch (JDOMException e1) {
                        e1.printStackTrace();
                    }
                    ProcessorParametersTab.this.selectedProcIndex = ProcessorParametersTab.this.Processor_list.getSelectedIndex();
                    if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                        configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                        ProcessorParametersTab.this.loadConfigProcessorField(configProc);
                    }
                }
            }
        });
        this.ADD_Processor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProcessorParametersTab.this.processorNameComboBox.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(null, "Select a Processor name to create an instance !", null, 1);
                    return;
                }
                String new_type = ((ConfigProcessorName)ProcessorParametersTab.this.processorNameComboBox.getSelectedItem()).getProcessorName();
                String power_group_name = "";
                if (ProcessorParametersTab.this.groupNameComboBox.getSelectedIndex() != -1) {
                    power_group_name = ((ConfigPowerGroup)ProcessorParametersTab.this.groupNameComboBox.getSelectedItem()).getGroupName();
                }
                ConfigProcessor newProc = null;
                try {
                    if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                        ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                        String oldInstName = configProc.getInstanceName();
                        String newName = ProcessorParametersTab.this.instName.getText();
                        if (ProcessorParametersTab.this.config.existsConfigProcessorInstanceName(newName) && !oldInstName.equals(newName)) {
                            ProcessorParametersTab.this.instName.setText(oldInstName);
                            JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                        }
                        ProcessorParametersTab.this.saveConfigProcessorField(configProc);
                        ProcessorParametersTab.this.config.updateConfigProcessor(oldInstName, configProc);
                    }
                    newProc = new ConfigProcessor(ConfigProcessor.createInstanceName(ProcessorParametersTab.this.config.getConfigProcessorList(), "Core_"), new_type, power_group_name);
                    ProcessorParametersTab.this.config.addConfigProcessor(newProc);
                    ProcessorParametersTab.this.Model_Processor_list.addElement(newProc);
                }
                catch (JDOMException e1) {
                    e1.printStackTrace();
                }
                if (newProc != null) {
                    ProcessorParametersTab.this.Processor_list.setSelectedValue(newProc, true);
                    ProcessorParametersTab.this.selectedProcIndex = ProcessorParametersTab.this.Processor_list.getSelectedIndex();
                }
                if (ProcessorParametersTab.this.Processor_list.getModel().getSize() == 0) {
                    ProcessorParametersTab.this.Remove_Processor.setEnabled(false);
                } else {
                    ProcessorParametersTab.this.Remove_Processor.setEnabled(true);
                }
            }
        });
        this.Remove_Processor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int currentIndex = ProcessorParametersTab.this.Processor_list.getSelectedIndex();
                    ProcessorParametersTab.this.selectedProcIndex = -1;
                    ConfigProcessor configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.Processor_list.getSelectedIndex());
                    ProcessorParametersTab.this.config.removeConfigProcessor(configProc);
                    ProcessorParametersTab.this.Model_Processor_list.removeElementAt(ProcessorParametersTab.this.Processor_list.getSelectedIndex());
                    if (!ProcessorParametersTab.this.Model_Processor_list.isEmpty()) {
                        if (currentIndex < ProcessorParametersTab.this.Model_Processor_list.size()) {
                            ProcessorParametersTab.this.Processor_list.setSelectedIndex(currentIndex);
                        } else {
                            ProcessorParametersTab.this.Processor_list.setSelectedIndex(ProcessorParametersTab.this.Model_Processor_list.size() - 1);
                        }
                    }
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
                if (ProcessorParametersTab.this.Processor_list.getModel().getSize() == 0) {
                    ProcessorParametersTab.this.Remove_Processor.setEnabled(false);
                } else {
                    ProcessorParametersTab.this.Remove_Processor.setEnabled(true);
                }
            }
        });
        this.Duplicate_Processor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ProcessorParametersTab.this.Processor_list.getSelectedIndex() != -1) {
                    try {
                        ConfigProcessor configProc;
                        if (ProcessorParametersTab.this.selectedProcIndex != -1) {
                            configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.selectedProcIndex);
                            String oldInstName = configProc.getInstanceName();
                            String newName = ProcessorParametersTab.this.instName.getText();
                            if (ProcessorParametersTab.this.config.existsConfigProcessorInstanceName(newName) && !oldInstName.equals(newName)) {
                                ProcessorParametersTab.this.instName.setText(oldInstName);
                                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
                            }
                            ProcessorParametersTab.this.saveConfigProcessorField(configProc);
                            ProcessorParametersTab.this.config.updateConfigProcessor(oldInstName, configProc);
                        }
                        configProc = ProcessorParametersTab.this.Model_Processor_list.getElementAt(ProcessorParametersTab.this.Processor_list.getSelectedIndex());
                        ConfigProcessor newProc = new ConfigProcessor(configProc, ConfigProcessor.createInstanceName(ProcessorParametersTab.this.config.getConfigProcessorList(), "Core_"));
                        ProcessorParametersTab.this.config.addConfigProcessor(newProc);
                        ProcessorParametersTab.this.Model_Processor_list.addElement(newProc);
                        ProcessorParametersTab.this.Processor_list.setSelectedValue(newProc, true);
                        ProcessorParametersTab.this.selectedProcIndex = ProcessorParametersTab.this.Processor_list.getSelectedIndex();
                    }
                    catch (JDOMException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void applyProcessorParameters() throws JDOMException, IOException {
        if (this.selectedProcIndex != -1) {
            ConfigProcessor configProc = this.Model_Processor_list.getElementAt(this.selectedProcIndex);
            String oldInstName = configProc.getInstanceName();
            String newName = this.instName.getText();
            if (this.config.existsConfigProcessorInstanceName(newName) && !oldInstName.equals(newName)) {
                this.instName.setText(oldInstName);
                JOptionPane.showMessageDialog(null, "This instance name " + newName + " is already used !", null, 1);
            }
            this.saveConfigProcessorField(configProc);
            this.config.updateConfigProcessor(oldInstName, configProc);
        }
    }

    public void getProcessorParameter() {
        try {
            this.Model_Processor_list.removeAllElements();
            this.setProcessorList(this.Model_Processor_list);
            if (this.Processor_list.getModel().getSize() == 0) {
                this.Remove_Processor.setEnabled(false);
            } else {
                this.Remove_Processor.setEnabled(true);
            }
            Vector<ConfigProcessorName> list = this.pref.getConfigProcessorNameList();
            int i = 0;
            while (i < list.size()) {
                this.processorNameComboBox.addItem(list.elementAt(i));
                this.inst_processorNameComboBox.addItem(list.elementAt(i).getProcessorName());
                ++i;
            }
            Vector<ConfigPowerGroup> list1 = this.pref.getRZConfigPowerGroupList();
            int i2 = 0;
            while (i2 < list1.size()) {
                this.rz_groupNameComboBox.addItem(list1.elementAt(i2));
                this.rz_default_groupNameComboBox.addItem(list1.elementAt(i2).getGroupName());
                ++i2;
            }
            this.rz_default_groupNameComboBox.setSelectedItem(this.config.getRZDefaultGroupName());
            Vector<ConfigPowerGroup> list2 = this.pref.getProcConfigPowerGroupList();
            int i3 = 0;
            while (i3 < list2.size()) {
                this.groupNameComboBox.addItem(list2.elementAt(i3));
                this.inst_groupNameComboBox.addItem(list2.elementAt(i3).getGroupName());
                ++i3;
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public void setProcessorList(DefaultListModel<ConfigProcessor> Model_Processor_list) throws JDOMException {
        Vector<ConfigProcessor> Report_list = this.config.getConfigProcessorList();
        Iterator i = Report_list.iterator();
        i = Report_list.iterator();
        if (Report_list != null) {
            while (i.hasNext()) {
                ConfigProcessor x = (ConfigProcessor)i.next();
                if (x == null) continue;
                Model_Processor_list.addElement(x);
            }
        }
        if (!Model_Processor_list.isEmpty()) {
            this.Processor_list.setSelectedIndex(0);
            this.selectedProcIndex = 0;
            ConfigProcessor ca = Model_Processor_list.getElementAt(0);
            this.loadConfigProcessorField(ca);
        }
    }

    public boolean existApplicationInList(ConfigProcessor App) {
        int j = 0;
        while (j < this.Model_Processor_list.getSize()) {
            if (this.Model_Processor_list.getElementAt(j).equals(App.toString())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() == this.ADD_RZGroup) {
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "New RZ Group");
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigPowerGroup cpg = pid.getPowerGroup();
                    if (this.existRZGroupName(cpg.getGroupName()) != -1) {
                        JOptionPane.showMessageDialog(null, "This RZ group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                    } else {
                        this.rz_groupNameComboBox.addItem(cpg);
                        this.rz_default_groupNameComboBox.addItem(cpg.getGroupName());
                        this.pref.addRZConfigPowerGroup(cpg);
                    }
                }
            } else if (event.getSource() == this.Edit_RZGroup) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.rz_groupNameComboBox.getSelectedItem();
                if (cpg == null) {
                    return;
                }
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "Edit RZ Group", cpg);
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigPowerGroup new_cpg = pid.getPowerGroup();
                    if (!new_cpg.equals(cpg)) {
                        int index = this.existRZGroupName(new_cpg.getGroupName());
                        if (index != -1) {
                            JOptionPane.showMessageDialog(null, "This RZ group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                        } else {
                            this.updateRZGroupName(cpg.getGroupName(), new_cpg);
                            this.updateNameComboBox(this.rz_default_groupNameComboBox, cpg.getGroupName(), new_cpg.getGroupName());
                            this.pref.updateRZConfigPowerGroup(cpg.getGroupName(), new_cpg);
                        }
                    } else {
                        this.updateRZGroupName(cpg.getGroupName(), new_cpg);
                        this.pref.updateRZConfigPowerGroup(cpg.getGroupName(), new_cpg);
                    }
                }
            } else if (event.getSource() == this.Remove_RZGroup) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.rz_groupNameComboBox.getSelectedItem();
                int index = this.rz_groupNameComboBox.getSelectedIndex();
                if (index != -1) {
                    this.rz_groupNameComboBox.removeItemAt(index);
                }
                if (this.rz_default_groupNameComboBox.getSelectedIndex() != -1) {
                    this.rz_default_groupNameComboBox.removeItem(cpg.getGroupName());
                }
                this.pref.removeRZConfigPowerGroup(cpg);
            } else if (event.getSource() == this.Duplicate_RZGroup) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.rz_groupNameComboBox.getSelectedItem();
                if (cpg == null) {
                    return;
                }
                String name = cpg.getGroupName();
                int offset = 0;
                String new_name = String.valueOf(name) + "_" + offset;
                while (this.existRZGroupName(new_name) != -1) {
                    new_name = String.valueOf(name) + "_" + ++offset;
                }
                ConfigPowerGroup new_cpg = new ConfigPowerGroup(cpg);
                new_cpg.setGroupName(new_name);
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "New RZ Group", new_cpg);
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    cpg = pid.getPowerGroup();
                    if (this.existRZGroupName(cpg.getGroupName()) != -1) {
                        JOptionPane.showMessageDialog(null, "This group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                    } else {
                        this.rz_groupNameComboBox.addItem(cpg);
                        this.rz_default_groupNameComboBox.addItem(cpg.getGroupName());
                        this.pref.addRZConfigPowerGroup(cpg);
                    }
                }
            } else if (event.getSource() == this.ADD_Group) {
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "New Group");
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigPowerGroup cpg = pid.getPowerGroup();
                    if (this.existGroupName(cpg.getGroupName()) != -1) {
                        JOptionPane.showMessageDialog(null, "This group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                    } else {
                        this.groupNameComboBox.addItem(cpg);
                        this.inst_groupNameComboBox.addItem(cpg.getGroupName());
                        this.pref.addProcConfigPowerGroup(cpg);
                    }
                }
            } else if (event.getSource() == this.Edit_Group) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.groupNameComboBox.getSelectedItem();
                if (cpg == null) {
                    return;
                }
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "Edit Group", cpg);
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigPowerGroup new_cpg = pid.getPowerGroup();
                    if (!new_cpg.equals(cpg)) {
                        int index = this.existGroupName(new_cpg.getGroupName());
                        if (index != -1) {
                            JOptionPane.showMessageDialog(null, "This group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                        } else {
                            this.updateGroupName(cpg.getGroupName(), new_cpg);
                            this.updateNameComboBox(this.inst_groupNameComboBox, cpg.getGroupName(), new_cpg.getGroupName());
                            this.pref.updateProcConfigPowerGroup(cpg.getGroupName(), new_cpg);
                        }
                    } else {
                        this.updateGroupName(cpg.getGroupName(), new_cpg);
                        this.pref.updateProcConfigPowerGroup(cpg.getGroupName(), new_cpg);
                    }
                }
            } else if (event.getSource() == this.Remove_Group) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.groupNameComboBox.getSelectedItem();
                int index = this.groupNameComboBox.getSelectedIndex();
                if (index != -1) {
                    this.groupNameComboBox.removeItemAt(index);
                }
                if (this.inst_groupNameComboBox.getSelectedIndex() != -1) {
                    this.inst_groupNameComboBox.removeItem(cpg.getGroupName());
                }
                this.pref.removeProcConfigPowerGroup(cpg);
            } else if (event.getSource() == this.Duplicate_Group) {
                ConfigPowerGroup cpg = (ConfigPowerGroup)this.groupNameComboBox.getSelectedItem();
                if (cpg == null) {
                    return;
                }
                String name = cpg.getGroupName();
                int offset = 0;
                String new_name = String.valueOf(name) + "_" + offset;
                while (this.existGroupName(new_name) != -1) {
                    new_name = String.valueOf(name) + "_" + ++offset;
                }
                ConfigPowerGroup new_cpg = new ConfigPowerGroup(cpg);
                new_cpg.setGroupName(new_name);
                PowerGroupInputDialog pid = new PowerGroupInputDialog((Frame)this.WindowsParameters, "New Group", new_cpg);
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    cpg = pid.getPowerGroup();
                    if (this.existGroupName(cpg.getGroupName()) != -1) {
                        JOptionPane.showMessageDialog(null, "This group domain name " + cpg.getGroupName() + " is already used !", null, 1);
                    } else {
                        this.groupNameComboBox.addItem(cpg);
                        this.inst_groupNameComboBox.addItem(cpg.getGroupName());
                        this.pref.addProcConfigPowerGroup(cpg);
                    }
                }
            } else if (event.getSource() == this.ADD_ProcessorName) {
                ProcessorInputDialog pid = new ProcessorInputDialog((Frame)this.WindowsParameters, "New Processor");
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigProcessorName cpn = pid.getConfigProcessorName();
                    if (this.existProcessorName(cpn.getProcessorName()) != -1) {
                        JOptionPane.showMessageDialog(null, "This processor name " + cpn.getProcessorName() + " is already used !", null, 1);
                    } else {
                        this.processorNameComboBox.addItem(cpn);
                        this.inst_processorNameComboBox.addItem(cpn.getProcessorName());
                        this.pref.addConfigProcessorName(cpn);
                    }
                }
            } else if (event.getSource() == this.Edit_ProcessorName) {
                ConfigProcessorName cpn = (ConfigProcessorName)this.processorNameComboBox.getSelectedItem();
                if (cpn == null) {
                    return;
                }
                ProcessorInputDialog pid = new ProcessorInputDialog((Frame)this.WindowsParameters, "Edit Processor", cpn);
                pid.setVisible(true);
                if (!pid.isCancelled()) {
                    ConfigProcessorName new_cpn = pid.getConfigProcessorName();
                    if (!new_cpn.equals(cpn)) {
                        int index = this.existProcessorName(new_cpn.getProcessorName());
                        if (index != -1) {
                            JOptionPane.showMessageDialog(null, "This processor name " + new_cpn.getProcessorName() + " is already used !", null, 1);
                        } else {
                            this.updateProcessorName(cpn.getProcessorName(), new_cpn);
                            this.updateNameComboBox(this.inst_processorNameComboBox, cpn.getProcessorName(), new_cpn.getProcessorName());
                            this.pref.updateConfigProcessorName(cpn.getProcessorName(), new_cpn);
                        }
                    } else {
                        this.updateProcessorName(cpn.getProcessorName(), new_cpn);
                        this.updateNameComboBox(this.inst_processorNameComboBox, cpn.getProcessorName(), new_cpn.getProcessorName());
                        this.pref.updateConfigProcessorName(cpn.getProcessorName(), new_cpn);
                    }
                }
            } else if (event.getSource() == this.Remove_ProcessorName) {
                ConfigProcessorName cpn = (ConfigProcessorName)this.processorNameComboBox.getSelectedItem();
                int index = this.processorNameComboBox.getSelectedIndex();
                if (index != -1) {
                    this.processorNameComboBox.removeItemAt(index);
                }
                if (this.inst_processorNameComboBox.getSelectedIndex() != -1) {
                    this.inst_processorNameComboBox.removeItem(cpn.getProcessorName());
                }
                this.pref.removeConfigProcessorName(cpn);
            }
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.groupNameComboBox) {
            ConfigPowerGroup cfr_ignored_0 = (ConfigPowerGroup)this.groupNameComboBox.getSelectedItem();
        } else if (event.getSource() == this.rz_default_groupNameComboBox) {
            try {
                String name = (String)this.rz_default_groupNameComboBox.getSelectedItem();
                if (name != null) {
                    this.config.setRZDefaultGroupName(name);
                }
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        } else if (event.getSource() == this.processorNameComboBox) {
            ConfigProcessorName cfr_ignored_1 = (ConfigProcessorName)this.processorNameComboBox.getSelectedItem();
        }
    }

    private int existProcessorName(String name) {
        int i = 0;
        while (i < this.processorNameComboBox.getItemCount()) {
            if (this.processorNameComboBox.getItemAt(i).getProcessorName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isSelectedProcessorName(String name) {
        return ((ConfigProcessorName)this.processorNameComboBox.getSelectedItem()).getProcessorName().equals(name);
    }

    private boolean updateProcessorName(String old_name, ConfigProcessorName new_cpg) {
        int index = this.existProcessorName(old_name);
        if (index == -1) {
            return false;
        }
        boolean defaultSel = this.isSelectedProcessorName(old_name);
        this.processorNameComboBox.removeItemAt(index);
        this.processorNameComboBox.addItem(new_cpg);
        if (defaultSel) {
            this.processorNameComboBox.setSelectedItem(new_cpg);
        }
        return true;
    }

    private int existGroupName(String name) {
        int i = 0;
        while (i < this.groupNameComboBox.getItemCount()) {
            if (this.groupNameComboBox.getItemAt(i).getGroupName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isSelectedGroupName(String name) {
        return ((ConfigPowerGroup)this.groupNameComboBox.getSelectedItem()).getGroupName().equals(name);
    }

    private boolean updateGroupName(String old_name, ConfigPowerGroup new_cpg) {
        int index = this.existGroupName(old_name);
        if (index == -1) {
            return false;
        }
        boolean defaultSel = this.isSelectedGroupName(old_name);
        this.groupNameComboBox.removeItemAt(index);
        this.groupNameComboBox.addItem(new_cpg);
        if (defaultSel) {
            this.groupNameComboBox.setSelectedItem(new_cpg);
        }
        return true;
    }

    private int existRZGroupName(String name) {
        int i = 0;
        while (i < this.rz_groupNameComboBox.getItemCount()) {
            if (this.rz_groupNameComboBox.getItemAt(i).getGroupName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isSelectedRZGroupName(String name) {
        return ((ConfigPowerGroup)this.rz_groupNameComboBox.getSelectedItem()).getGroupName().equals(name);
    }

    private boolean updateRZGroupName(String old_name, ConfigPowerGroup new_cpg) {
        int index = this.existRZGroupName(old_name);
        if (index == -1) {
            return false;
        }
        boolean defaultSel = this.isSelectedRZGroupName(old_name);
        this.rz_groupNameComboBox.removeItemAt(index);
        this.rz_groupNameComboBox.addItem(new_cpg);
        if (defaultSel) {
            this.rz_groupNameComboBox.setSelectedItem(new_cpg);
        }
        return true;
    }

    private int existNameComboBox(JComboBox<String> combo, String name) {
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItemAt(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isNameComboBox(JComboBox<String> combo, String name) {
        return ((String)combo.getSelectedItem()).equals(name);
    }

    private void updateNameComboBox(JComboBox<String> combo, String old_name, String new_name) {
        int index = this.existNameComboBox(combo, old_name);
        if (index == -1) {
            combo.addItem(new_name);
        } else {
            boolean defaultSel = this.isNameComboBox(combo, old_name);
            combo.removeItemAt(index);
            combo.addItem(new_name);
            if (defaultSel) {
                combo.setSelectedItem(new_name);
            }
        }
    }

    public class AppListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ConfigProcessor configProc = (ConfigProcessor)value;
            if (configProc.isActive()) {
                label.setIcon(new ImageIcon(FortressEnv.getImageFile("enable-app.png")));
            } else {
                label.setIcon(new ImageIcon(FortressEnv.getImageFile("disable-app.png")));
            }
            String powerDomain = "";
            if (configProc.getPowerGroupName() != "") {
                powerDomain = ", Power Domain: " + configProc.getPowerGroupName();
            }
            String text = configProc.hasInterfaces() ? String.valueOf(configProc.getInstanceName()) + "  [" + configProc.getType() + powerDomain + ", Context Switch Time = " + configProc.getContextSwitchTime() + " us, Interfaces = " + configProc.getInterfaces() + " ]" : String.valueOf(configProc.getInstanceName()) + "  [" + configProc.getType() + powerDomain + ", Context Switch Time = " + configProc.getContextSwitchTime() + " us ]";
            label.setText(text);
            return label;
        }
    }
}

