/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import Modulesystem.diagram.commands.SystemParametersTab;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jdom.JDOMException;

public class PreferencesHandler
extends AbstractHandler {
    JFrame WindowsParameters = null;
    FortressConfiguration config = null;
    FortressPreferences pref = null;
    boolean windowsParametersActive = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.pref = FortressEnv.getFortressPreferences();
            if (this.pref != null) {
                this.pref.loadFile();
                this.config = new FortressConfiguration();
                String activeConf = this.pref.getActiveConfiguration();
                if (activeConf != null) {
                    this.config.loadFile(activeConf);
                }
                if (!this.windowsParametersActive) {
                    this.create_dialog();
                    this.WindowsParameters.setVisible(true);
                    this.WindowsParameters.toFront();
                } else {
                    this.WindowsParameters.toFront();
                }
            } else {
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                console.println("Open or Create a project");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void create_dialog() {
        this.WindowsParameters = new JFrame();
        this.WindowsParameters.setSize(950, 650);
        this.WindowsParameters.setResizable(false);
        this.WindowsParameters.setLocationRelativeTo(this.WindowsParameters);
        this.windowsParametersActive = true;
        JTabbedPane Tab = new JTabbedPane();
        final SystemParametersTab T_SystemParameters = new SystemParametersTab(this.WindowsParameters, Tab, this.pref, this.config);
        T_SystemParameters.CreateSystemParametersTab();
        T_SystemParameters.getPreference();
        T_SystemParameters.getonglet_configuration();
        try {
            T_SystemParameters.setTitle(this.pref.getActiveConfiguration());
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
        JButton Restore_defaults = new JButton("Restore Defaults");
        JButton Apply = new JButton("Apply");
        JButton Cancel = new JButton("Cancel");
        JPanel Command_Parameter = new JPanel();
        Command_Parameter.setLayout(new FlowLayout(4));
        Command_Parameter.add(Restore_defaults);
        Command_Parameter.add(Apply);
        Command_Parameter.add(Cancel);
        Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    PreferencesHandler.this.pref.loadFile();
                    PreferencesHandler.this.config.loadFile(PreferencesHandler.this.pref.getActiveConfiguration());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PreferencesHandler.this.WindowsParameters.dispose();
                PreferencesHandler.this.windowsParametersActive = false;
                PreferencesHandler.this.WindowsParameters = null;
            }
        });
        Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                T_SystemParameters.applyPreference();
                T_SystemParameters.applyConfiguration();
                try {
                    PreferencesHandler.this.pref.saveFile();
                    PreferencesHandler.this.config.saveFile(PreferencesHandler.this.pref.getActiveConfiguration());
                    FortressConsole.loadLogFile(PreferencesHandler.this.pref.getActiveConfiguration());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(FortressEnv.getTitle(FortressEnv.getProjectPath().substring(0, FortressEnv.getProjectPath().length() - 1), (this).PreferencesHandler.this.pref.getActiveConfiguration()));
                        }
                        catch (JDOMException e) {
                            e.printStackTrace();
                        }
                    }
                });
                PreferencesHandler.this.WindowsParameters.dispose();
                PreferencesHandler.this.windowsParametersActive = false;
            }
        });
        Restore_defaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                T_SystemParameters.getDefaultConfiguration();
            }
        });
        JPanel p_WindowsParameters = new JPanel();
        GroupLayout g_WindowsParameters = new GroupLayout(p_WindowsParameters);
        p_WindowsParameters.setLayout(g_WindowsParameters);
        g_WindowsParameters.setHorizontalGroup(g_WindowsParameters.createParallelGroup().addComponent(Tab).addComponent(Command_Parameter));
        g_WindowsParameters.setVerticalGroup(g_WindowsParameters.createSequentialGroup().addComponent(Tab).addComponent(Command_Parameter));
        p_WindowsParameters.setEnabled(false);
        this.WindowsParameters.add(p_WindowsParameters);
        this.WindowsParameters.toFront();
        this.WindowsParameters.setDefaultCloseOperation(2);
        this.WindowsParameters.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesHandler.this.windowsParametersActive = false;
            }
        });
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

