/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.generation.ReplaceKeyword;
import fortress.xml.FortressPreferences;
import jfb.gmf.modulesystem.ModulesystemPackage;
import jfb.gmf.modulesystem.TestBench;
import jfb.gmf.modulesystem.diagram.edit.parts.TestBenchEditPart;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewTestBench_ThreadHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGraphicalEditPart editPart;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection && (editPart = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement()) instanceof TestBenchEditPart) {
            TestBenchEditPart testbenchEditPart = (TestBenchEditPart)editPart;
            TestBench mod = (TestBench)testbenchEditPart.resolveSemanticElement();
            EList targetConnectionList = mod.getTargetConnection();
            boolean testbench_in = targetConnectionList.size() == 0;
            TransactionalEditingDomain domain = testbenchEditPart.getEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
            FileDialog fileDialog = new FileDialog(shell, 4096);
            if (testbench_in) {
                fileDialog.setText("New IN TestBench File");
            } else {
                fileDialog.setText("New OUT TestBench File");
            }
            fileDialog.setFilterPath(FortressEnv.getUserBenchesSourcePath());
            String[] filterExt = new String[]{"*.h"};
            fileDialog.setFilterExtensions(filterExt);
            String name = fileDialog.open();
            if (name != null) {
                String template_filename = testbench_in ? FortressEnv.getTemplateUserInTestbenchFile() : FortressEnv.getTemplateUserOutTestbenchFile();
                if (!(name = FortressEnv.transformToIdWithPath(name.trim())).endsWith(".h")) {
                    name = String.valueOf(name) + ".h";
                }
                String filename = name;
                name = FortressEnv.extractFilenameWithoutExtension(name);
                if (FortressEnv.isExistFile(filename)) {
                    MessageBox messageDialog = new MessageBox(shell, 1);
                    messageDialog.setText("Error");
                    messageDialog.setMessage("The Testbench " + name + ".h already exists !");
                    messageDialog.open();
                    return null;
                }
                ReplaceKeyword rk = new ReplaceKeyword(template_filename, filename);
                String buf = "/**" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * @file    " + name + ".h" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * @author  XXX" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * @version 1.0" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * @date    " + FortressEnv.today() + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * @section DESCRIPTION" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  * " + FortressEnv.EOL;
                buf = testbench_in ? String.valueOf(buf) + "  * User IN Testbench algorithms files of " + name + FortressEnv.EOL : String.valueOf(buf) + "  * User OUT Testbench algorithms files of " + name + FortressEnv.EOL;
                buf = String.valueOf(buf) + "  */" + FortressEnv.EOL;
                buf = String.valueOf(buf) + FortressEnv.EOL;
                rk.addReplaceKeyword("FORTRESS_HEADER", buf);
                buf = name;
                rk.addReplaceKeyword("RECOSIM_USER_HANDLER", buf);
                buf = name.toUpperCase();
                rk.addReplaceKeyword("RECOSIM_USER_UPPER_HANDLER", buf);
                try {
                    rk.Generate();
                    commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getTestBench_TestBench_Thread(), (Object)name));
                    FortressEnv.openTextEditor(filename);
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && !pref.getTextEditorPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

