#ifndef RS_SOCKET
#define RS_SOCKET
#include "memory_manager.h"
#include <iostream>
#include <assert.h>
#include <vector>
#include <map>
#include <thread>


//class initiator_socket;
//class target_socket;
//class simple_initiator_socket;
//template<typename MODULE>
//class simple_target_socket;
//class multi_initiator_socket;
//class multi_target_socket;
/*****************************************************
*****************************************************/
enum rs_phase_enum { UNINITIALIZED_PHASE=0, BEGIN_REQ=1, END_REQ, BEGIN_RESP, END_RESP };

inline unsigned int create_phase_number(){
   static unsigned int number=END_RESP+1;
    return number++;
}
  
inline std::vector<const char*>& get_phase_name_vec(){
    static std::vector<const char*> phase_name_vec(END_RESP+1, (const char*)NULL);
    return phase_name_vec;
}

class rs_phase{
public:
   rs_phase(): m_id(0) {}
   rs_phase(unsigned int id): m_id(id){}
   rs_phase(const rs_phase_enum& standard): m_id((unsigned int) standard){}
   rs_phase& operator=(const rs_phase_enum& standard){m_id=(unsigned int)standard; return *this;}
   operator unsigned int() const{return m_id;}
   
private:
   unsigned int m_id;  
};


inline
std::ostream& operator<<(std::ostream& s, const rs_phase& p){
   switch ((unsigned int)p){
	   case UNINITIALIZED_PHASE: s<<"UNINITIALIZED_PHASE"; break;
	   case BEGIN_REQ:  s<<"BEGIN_REQ"; break;
	   case END_REQ:    s<<"END_REQ"; break;
	   case BEGIN_RESP: s<<"BEGIN_RESP"; break;
	   case END_RESP:   s<<"END_RESP"; break;
	   default :        s<<get_phase_name_vec()[(unsigned int)p]; return s;
   }
   return s;
}


#define TLM_DECLARE_EXTENDED_PHASE(name_arg) \
class rs_phase_##name_arg:public rs_phase{ \
public:\
static const rs_phase_##name_arg& get_phase(){static rs_phase_##name_arg tmp; return tmp;}\
private:\
rs_phase_##name_arg():rs_phase(create_phase_number()){get_phase_name_vec().push_back(get_char_##name_arg());};\
rs_phase_##name_arg(const rs_phase_##name_arg&); \
rs_phase_##name_arg& operator=(const rs_phase_##name_arg&); \
static inline const char* get_char_##name_arg(){static const char* tmp=#name_arg; return tmp;} \
}; \
static const rs_phase_##name_arg& name_arg=rs_phase_##name_arg::get_phase()
 
// for backwards-compatibility
#define DECLARE_EXTENDED_PHASE(NameArg) \
    TLM_DECLARE_EXTENDED_PHASE( NameArg )



/*****************************************************
*****************************************************/
enum rs_sync_enum { RS_ACCEPTED, RS_UPDATED, RS_COMPLETED };

/*****************************************************
*****************************************************/

class target_socket{
public :
	virtual void 		b_transport	(rs_payload& trans) = 0;
};
class initiator_socket{
public :
	virtual void		b_transport	(rs_payload& trans) = 0;
};
class bw_link{
public :
	virtual rs_sync_enum	nb_transport_bw(int id, rs_payload& pa, rs_phase& ph) = 0;
};
class fw_link{
public :
	virtual int 		bind(int, bw_link* ) = 0;
	virtual int 		bind(initiator_socket* ) = 0;
	virtual void		b_transport(int, rs_payload&) = 0;
	virtual rs_sync_enum	nb_transport_fw(int id, rs_payload& pa, rs_phase& ph) = 0;
};


/*****************************************************
*****************************************************/
template<typename MODULE>
class socket_initiator {
public  :
	typedef void (MODULE::*BTransportPtr)(rs_payload&);
public :
	virtual void b_transport(rs_payload*);
	virtual void register_b_transport(MODULE *,BTransportPtr);
};



class calback_binder_fw{
private :
	int 			m_id;
	fw_link* 		m_mtarget;
	target_socket*		m_starget;
public :
	calback_binder_fw(int _id, fw_link* _target) :m_id(_id), m_mtarget(_target), m_starget(0){}
	calback_binder_fw(int _id, target_socket* _starget) :m_id(_id), m_mtarget(0), m_starget(_starget){}

	void	b_transport(rs_payload& pa)
	{
		assert(m_starget != 0 || m_mtarget != 0);
		if (m_starget !=0)
			m_starget->b_transport(pa);
		else if (m_mtarget != 0)
			m_mtarget->b_transport(m_id,pa);
	}
	rs_sync_enum 	nb_transport_fw(rs_payload& pa, rs_phase& ph)
	{
		assert(m_mtarget != 0);
		return m_mtarget->nb_transport_fw(m_id,pa,ph);
	}
};



/*****************************************************
*****************************************************/
template<typename MODULE>
class simple_target_socket: public target_socket {
public  :
	typedef void (MODULE::*BTransportPtr)(rs_payload&);

private :
	MODULE* m_module;
	BTransportPtr b_transport_f;
public :
	simple_target_socket()
	:m_module(0) 
	,b_transport_f(0)
	{}

	~simple_target_socket()
	{}

	void register_b_transport(MODULE *mod, BTransportPtr b_transport_handler){
		m_module = mod;
		b_transport_f = b_transport_handler;
		//std::cout << "REGISTER target" << std::endl;
	}

	void b_transport(rs_payload& trans){
		assert(m_module!=0);
		assert(b_transport_f!=0);
		(m_module->*b_transport_f)(trans);
	}
};

/*****************************************************
*****************************************************/

template<typename MODULE>
class simple_initiator_socket :public initiator_socket{
private :
	MODULE* m_module;
	target_socket* m_target;
	calback_binder_fw* cb_fw;
public :
	simple_initiator_socket()
	:m_module(0)
	,m_target(0)
	,cb_fw(0)
	{}
	~simple_initiator_socket(){}

	void bind(target_socket* target)
	{
		m_target = target;
	}
	void bind(fw_link* _target)// not thread safe
	{
		cb_fw = new calback_binder_fw(_target->bind(this) ,_target);
	}

	void b_transport(rs_payload& trans){
		assert(m_target!=0 || cb_fw!=0);
		if (m_target != 0)
			m_target->b_transport(trans);
		else if (cb_fw != 0)
			cb_fw->b_transport(trans);
	}

};

/*****************************************************
*****************************************************/

class multi_initiator_base : public bw_link{
public :
	virtual void 		bind(fw_link*) = 0;
	virtual rs_sync_enum	nb_transport_bw(int id, rs_payload& pa, rs_phase& ph) = 0;
};

class multi_target_base : public fw_link{
public :
	virtual int		bind(int, bw_link* ) = 0;
	virtual int 		bind(initiator_socket* ) = 0;
	virtual rs_sync_enum 	nb_transport_fw(int id, rs_payload& pa, rs_phase& ph) = 0;
};
/*****************************************************
*****************************************************/

template<typename MODULE>
class multi_passthrough_initiator_socket : public multi_initiator_base {
	typedef rs_sync_enum (MODULE::*NBTransportBWPtr)(int, rs_payload&, rs_phase&);
private :
	MODULE* m_module;
	NBTransportBWPtr nb_transport_bw_f;

	std::vector<calback_binder_fw*> m_mtarget;
	//std::vector<target_socket*> m_starget;
	
public :
	multi_passthrough_initiator_socket()
	: m_module(0)
	, m_mtarget()
	, nb_transport_bw_f(0)
	{}
	~multi_passthrough_initiator_socket(){}

	void register_nb_transport_bw(MODULE* _module,NBTransportBWPtr _f)
	{
		m_module 		= _module;
		nb_transport_bw_f 	= _f;
	}

	void bind(target_socket* _target)
	{
		calback_binder_fw* cb_fw = new calback_binder_fw(0,_target);
		m_mtarget.push_back(cb_fw);
	}
	void bind(fw_link* _target)// not thread safe
	{
		calback_binder_fw* cb_fw = new calback_binder_fw(_target->bind(m_mtarget.size(),this) ,_target);
		m_mtarget.push_back(cb_fw);
	}
	rs_sync_enum 	nb_transport_bw(int id, rs_payload& pa, rs_phase& ph)
	{
		assert(nb_transport_bw_f != 0);
		return (m_module->*nb_transport_bw_f)(id,pa,ph);
	}
	calback_binder_fw* operator[](int i){return m_mtarget[i];}
	
};



/*****************************************************
*****************************************************/
class calback_binder_bw{
private :
	int 			m_id;
	bw_link* 		m_minitiator;
	initiator_socket*	m_sinitiator;
public :
	calback_binder_bw(int _id, bw_link* _initiator):m_id(_id),m_minitiator(_initiator),m_sinitiator(0){}
	calback_binder_bw(initiator_socket* _initiator):m_id(0),m_minitiator(0),m_sinitiator(_initiator){}
	rs_sync_enum nb_transport_bw(rs_payload pa, rs_phase ph)
	{
		assert(m_minitiator != 0);
		return m_minitiator->nb_transport_bw(m_id,pa,ph);
	}
};




template<typename MODULE>
class multi_passthrough_target_socket : public multi_target_base{
	typedef rs_sync_enum (MODULE::*NBTransportFWPtr)(int, rs_payload&, rs_phase&);
	typedef void(MODULE::*BTransportPtr)(int, rs_payload&);
private :
	MODULE* m_module;
	NBTransportFWPtr nb_transport_fw_f;
	BTransportPtr	 b_transport_f;
	std::vector<calback_binder_bw*> m_minitiator;
public :
	int bind(int my_id, bw_link* _initiator)
	{
		calback_binder_bw* binder_tmp = new calback_binder_bw(my_id,_initiator);
		m_minitiator.push_back(binder_tmp);
		return m_minitiator.size()-1;
	}
	int bind(initiator_socket* _initiator)
	{
		calback_binder_bw* binder_tmp = new calback_binder_bw(_initiator);
		m_minitiator.push_back(binder_tmp);
		return m_minitiator.size()-1;
		
	}
	void register_nb_transport_fw(MODULE* _module, NBTransportFWPtr _f)
	{
		m_module 		= _module;
		nb_transport_fw_f 	= _f;
	}
	void register_b_transport(MODULE* _module, BTransportPtr _f)
	{
		m_module		= _module;
		b_transport_f		= _f;
	}
	rs_sync_enum 	nb_transport_fw(int id, rs_payload& pa, rs_phase& ph)
	{
		return (m_module->*nb_transport_fw_f)(id,pa,ph);
	}
	void	b_transport(int id, rs_payload& pa)
	{
		(m_module->*b_transport_f)(id,pa);
	}
	calback_binder_bw* operator[](int i){return m_minitiator[i];}
};

/*****************************************************
*****************************************************/
template<typename MODULE>
class peq_with_cb_and_phase {
	typedef std::pair<rs_payload*,rs_phase> PAYLOAD;
	typedef void (MODULE::*cb)(rs_payload&, const rs_phase&);


	class delta_list{
	public:
		delta_list(){
			reset();
			entries.resize(100);
		}

		inline void insert(const PAYLOAD& p){
			if (size==entries.size()){
			entries.resize(entries.size()*2);
			}
			entries[size++]=p;
		}
		
		inline PAYLOAD& get(){
			return entries[out++];
		}
		
		inline bool next(){
			return out<size;
		}
		
		inline void reset(){
			size=0;
			out=0;
		}
	public:
		unsigned int size;
	private:
		std::vector<PAYLOAD> entries;
		unsigned int out;
	};

public:
	peq_with_cb_and_phase(MODULE* _module ,cb _cb)
		:m_module(_module)
		,m_cb(_cb)
	{
		m_th = new std::thread(fec_helper,this);
	}

	void notify (rs_payload& t, const rs_phase& p){
		m_immediate_yield.insert(PAYLOAD(&t,p));
		m_e.notify();
	}

private:
	static void fec_helper(void *ctx){
		((peq_with_cb_and_phase<MODULE>*)ctx)->fec();
	}
	void fec(){
		while(1){
			m_e.wait();
			while(m_immediate_yield.next()){PAYLOAD& tmp=m_immediate_yield.get(); (m_module->*m_cb)(*tmp.first, tmp.second);}
			m_immediate_yield.reset();
		}
	}

	MODULE*		m_module;
	cb		m_cb;
	delta_list 	m_immediate_yield;
	rs_event	m_e;
	std::thread*	m_th;
};
#endif
