/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconfigurable_zone.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-11-24
 * @section DESCRIPTION
 *			Represents a RZ
 */

#ifndef RECONFIGURABLE_ZONE_H
#define RECONFIGURABLE_ZONE_H

#define SC_INCLUDE_DYNAMIC_PROCESSES

#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>
//#include <systemc.h>
#include "pe_implementation.h"
#include "resources.h"
//#include "simulation_controller.h"
#include "task_implementation.h"
//#include "window_function.h"
#include "rz_config.h"

using namespace std;

class RZ {

private:
	string name;


	string groupDomainName;
	Config_fct_point *current_cfg_fct_point;

	vector<TaskImplementation> taskImplementationVector;
	PEImplementation implementation;
	int cpuId;
	Resources resources;

	map<RZState, rs_time> occupationTimes;
	rs_time lastModificationTime;

	RZState state;

	int currentImplementationID;

	// Analog trace stuff
	rs_time requestTime;
	rs_time last_window_reset;
	
	//WindowFunction window_function[NB_RZ_STATES];
	rs_time stateTimeOnLastCall[NB_RZ_STATES];

public:
	RZ(string n, vector<TaskImplementation> vec, PEImplementation impl, int id) : name(n), taskImplementationVector(vec), implementation(impl), cpuId(id){

		current_cfg_fct_point = new Config_fct_point();
		//if(impl == HARD) Simulation_controller::get_logfile() << "RZ " << name << " can host: " << endl;
		//else if(impl == SOFT) Simulation_controller::get_logfile() << "Processor " << name << " can host: " << endl;

		//for(int i = 0; i < (int) taskImplementationVector.size(); i++) {
			//Simulation_controller::get_logfile() << "Implementation " << taskImplementationVector.at(i).getImplementationName() << " of task " << taskImplementationVector.at(i).getTaskName() 
			//	<< " (" << taskImplementationVector.at(i).getCompressedReconfigurationTime() << ", " << taskImplementationVector.at(i).getPreloadReconfigurationTime() << ") " << endl;
		//}

		// Init table
		occupationTimes[RZ_BLANK] = RS_ZERO_TIME;
		occupationTimes[RZ_RECONFIG] = RS_ZERO_TIME;
		occupationTimes[RZ_MAPPED] = RS_ZERO_TIME;
		occupationTimes[RZ_ACTIVE] = RS_ZERO_TIME;

		state = RZ_BLANK;

		currentImplementationID = 0;
	}

	string getName(void) const;
	PEImplementation get_implementation_type(void) const;
	vector<TaskImplementation> getTaskImplementationVector(void) const;
	vector<TaskImplementation>* getTaskImplementationVectorPtr(void);
	Resources* get_resources_ptr(void);
	int get_cpu_id(void) const;

	rs_time getOccupationTime(RZState state);
	RZState getRZState(void);
	void setRZState(RZState);
	void setCurrentImplementationID(int);
	TaskImplementation getCurrentImplementation(void);

	void setResources(map<string, int> &res);

	Config_fct_point& getConfigFctPoint();	
	void setConfigFctPoint(Config_fct_point*);
	void setGroupDomainName(string domainName);
	string getGroupDomainName();

	double getStateOccupationRateOverLastWindow(RZState);
	void resetWindow(void);

};

#endif
