/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    fpga.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-06-20
 * @section DESCRIPTION
 *			Device representation
 */

#ifndef FPGA_H
#define FPGA_H

#include "resources.h"
#include <string>
#include <set>
#include <map>
using namespace std;

class FPGA {

private:
	string deviceID;
	Resources resources;

public:
	FPGA(string id, map<string, int> _resourceMap) : deviceID(id), resources(_resourceMap) {}

	FPGA() : deviceID("undef") {};

	string get_device_ID(void);
	Resources get_resources(void);
};

#endif
