/**
 * UNS - CNRS
 * Copyright 2015 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    config_fct_point.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2015-04-02
 * @section DESCRIPTION
 *			Config Fct Point description
 */

#ifndef CONFIG_FCT_POINT_H
#define CONFIG_FCT_POINT_H

#include <string>
#include <set>
#include <map>
#include "utils.h"

//using namespace std;

class Config_fct_point {
	
	float voltage;
	float frequency;

public:
	Config_fct_point() {
		Config_fct_point(0,0);
	}

	Config_fct_point(float voltage_, float frequency_) {
		voltage = voltage_;
		frequency = frequency_;
	}
	
	Config_fct_point(Config_fct_point& cfg) {
		voltage = cfg.voltage;
		frequency = cfg.frequency;
	}

	Config_fct_point(const Config_fct_point& cfg) {
		voltage = cfg.voltage;
		frequency = cfg.frequency;
	}

	Config_fct_point(Config_fct_point* cfg) {
		voltage = cfg->voltage;
		frequency = cfg->frequency;
	}
	
	string toString() {
		return "( " + Utils::ftoa(voltage) + " V, " + Utils::ftoa(frequency) + " Hz )";
	}
		
	bool equals(Config_fct_point obj) {
		return obj.voltage == voltage && obj.frequency == frequency;
	}
	
	void setVoltage(float val) {
		voltage = val;
	}	
	
	void setFrequency(float val) {
		frequency = val;
	}	
	
	float getVoltage() {
		return voltage;
	}
	
	float getFrequency() {
		return frequency;
	}	
};
	
#endif