FORTRESS_HEADER

#ifndef RECOSIM_USER_UPPER_HANDLER_TESTBENCH_FILE_H
#define RECOSIM_USER_UPPER_HANDLER_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/*******************/
/* Input TestBench */
RECOSIM_USER_IF_IN_BEGIN
template<int Ni>
void RECOSIM_USER_HANDLER(Testbench_in_interface<Ni> &tb_interface) {
	
	/* Default Behavior */
	
	// Verify data 'on-the-fly'
	int nb_transactions_received = 0;
	int nb_diff = 0;
	int last_transaction_count[Ni];
	for(int i = 0; i < Ni; i++) last_transaction_count[i] = 0;

	while(nb_transactions_received != NB_TRANSACTIONS_TO_SEND * Ni) {

		/* Time out right before end of simulation */
		sc_time timeout(Reconfiguration_manager::getMaximumSimulationTime() - sc_time_stamp() - sc_time(1, SC_US));	
		wait(timeout, tb_interface.TB_IF_transaction_received_event());

		if(sc_time_stamp() == Reconfiguration_manager::getMaximumSimulationTime() - sc_time(1, SC_US)) {
			/* Reached end of simulation due to timeout, something is wrong with the testbench */
			cout << "CRITICAL WARNING: End of simulation reached but testbench thread is still waiting for transactions..." << endl;
			cout << "Testbench name: " << tb_interface.TB_IF_name();
			cout << "Consider revising:" << endl;
			cout << " - Testbench to wait for less transactions" << endl;
			cout << " - Module algorithms to send data more often" << endl;
			return;
		} 
		else {
			/* Event(s) received */
			for(int i = 0; i < Ni; i++) {
				if(tb_interface.TB_IF_get_nb_transactions_received_per_socket(i) != last_transaction_count[i]) {
					// Data received on this socket
					// Check data
					int *data_ptr = tb_interface.TB_IF_get_data_in_ptr(i);
					for(int j = 0; j < 16; j++) { 
						if(data_ptr[j] != ((last_transaction_count[i] << 16) | j)) {
							nb_diff++;
							cout << "Socket " << i << ", Transaction " << last_transaction_count[i] << ", Data " << j << " -> " << hex << data_ptr[j] << " (expected " << ((last_transaction_count[i] << 16) | j) << ")" << endl;
						}
					}

					// Update transaction count
					last_transaction_count[i]++;

					break;
				}
			}

			nb_transactions_received++;
		}

		
	}

	if(nb_diff == 0) {
		Simulation_controller::get_logfile() << endl << "==================================================" << endl;
		Simulation_controller::get_logfile() << "  CONGRATULATIONS: Simulation ended successfully  " << endl;
		Simulation_controller::get_logfile() << "==================================================" << endl << endl;

		// Communicate with the simulation controller
		tb_interface.TB_IF_notify_simulation_controller(true);
	} else {
		Simulation_controller::get_logfile() << endl << "==================================================" << endl;
		Simulation_controller::get_logfile() << "         Simulation failed with " << dec << nb_diff << " errors            " << endl;
		Simulation_controller::get_logfile() << "==================================================" << endl << endl;

		exit(RECOSIM_TESTBENCH_CHECK_FAILED);
	}
}
RECOSIM_USER_IF_IN_END

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
