/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit� de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    recosim_parameters.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2014/06/04
 * @date    January 24, 2016 3:10:00 PM CET
 * @section DESCRIPTION
 *
 *          RecoSim parameters for xc6vlx240t device (Virtex6)
*/

#define FORTRESS_CONFIGURATION Config_1


#include "reconfiguration_manager.h"
#include "user_parameters.h"

sc_time Reconfiguration_manager_base::MAXIMUM_SIMULATION_TIME = sc_time(120.0, SC_SEC);

sc_time Reconfiguration_manager_base::SCHEDULER_EXECUTION_TIME = sc_time(0, SC_US); 
double Reconfiguration_manager_base::SCHEDULER_ENERGY_CONSUMPTION = 0;
double Reconfiguration_manager_base::ENERGY_CONSUMPTION_LIMIT = 5000;
bool Reconfiguration_manager_base::GENERATE_ZERO_FILLED_LINE_IN_CSV = false; 
sc_time Reconfiguration_manager_base::TRACE_WINDOW_FUNCTION_LENGTH = sc_time(10000.0, SC_US);
bool Reconfiguration_manager_base::ALL_DEPENDENCIES_REQUIRED_BEFORE_REQUEST = false;

double Reconfiguration_manager_base::SCHEDULER_PERFORMANCE_EFFORT = 100;
double Reconfiguration_manager_base::SCHEDULER_POWER_EFFORT = 0;
double Reconfiguration_manager_base::SCHEDULER_AREA_EFFORT = 0;

int Reconfiguration_manager_base::NB_HW_RECONFIGURATION_UNITS = 1;
int Reconfiguration_manager_base::NB_SW_RECONFIGURATION_UNITS = 1;

