/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    qos_interface.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2013/06/10
 * @date    July 22, 2014 2:10:21 PM CEST
 * @section DESCRIPTION
 *
 *          QoS Interface to manage the QoS
*/

#ifndef QOS_INTERFACE_H
#define QOS_INTERFACE_H

#include <systemc.h>

using namespace std;

#define QOS_COMMON_ACTIVATE virtual void activate_common_trace(int ApplicationNumber)

#define QOS_APPLICATION_ACTIVATE virtual void activate_application_trace(int applicationID, Application &application)

#define QOS_TRACE(var_name, displayed_name, format) sc_trace(services.getTraceFile(), var_name, displayed_name);

#define QOS_APPLICATION_THREAD virtual void  QoS_application_thread(int applicationID, Application &application, int monitoringThreadID)

#define QOS_COMMON_THREAD virtual void QoS_common_thread(int ApplicationNumber, int monitoringThreadID)


class QoS_interface {

public:

	/**
	 * @brief Get the trace file
	 * @return trace file pointer
	 */
	virtual sc_trace_file* getTraceFile() const = 0;

	/**
	 * @brief Get the scheduler interface
	 * @return scheduler interface pointer
	 */
	virtual Scheduler_interface& getShedulerInterface() = 0;

	/**
	 * @brief Get the list of application(s)
	 * @return vector of Application
	 */
	virtual vector<Application>& getApplications() = 0;


	/**
	 * @brief Get the event notified at the start of the scheduling decision. The monitoring thread can wait on the event.
	 * @return event of end of scheduling
	 */
	virtual sc_event& startOfSchedulingEvent(int id) = 0;

	/**
	 * @brief Get the event notified at the end of the scheduling decision. The monitoring thread can wait on the event.
	 * @return event of end of scheduling
	 */
	virtual sc_event& endOfSchedulingEvent(int id) = 0;
	
	/**
	 * @brief Get the event notified when the RZ state changed. The monitoring thread can wait on the event.
	 * @return event of end of scheduling
	 */
	virtual sc_event& updateRZStateEvent(int id) = 0;

	/**
	 * @brief Get the event notified when the task state changed. The monitoring thread can wait on the event.
	 * @return event of end of scheduling
	 */
	virtual sc_event& updateTaskStateEvent(int id) = 0;

};

#endif
