/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    monitoring.h
 * @author  Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2013/06/10
 * @date    June 25, 2014 2:10:21 PM CEST
 * @section DESCRIPTION
 *
 *          Monitoring and Trace Metrics
*/

#ifndef MONITORING_H
#define MONITORING_H

#include "monitoring_interface.h"

class Monitoring : public sc_module {

public:

	static int thread_number;

	string monitoring_name;

	Monitoring_interface& services;

	Monitoring(sc_module_name nm, Monitoring_interface& _monitoring_if) : sc_module(nm), services(_monitoring_if) {
		this->monitoring_name = name();
	}

	int static get_thread_number() {
		return thread_number;
	}

};


#endif
