/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    sort.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-01-19
 * @section DESCRIPTION
 *			Sort algorithms
 */

#ifndef SORT_H
#define SORT_H

#include "RZ.h"
#include <cstdlib>

void quickSort(vector<RZ> &vec, int begin, int end) {

	if(begin < end) {

		int left = begin - 1;
		int right = end + 1;
		// Random pivot
		//int pivot = (rand() % (end - begin + 1)) + begin;
		int pivot = (end - begin - 1) + begin;
		int pivotVal = vec.at(pivot).getRZCost();

		while(1) {
			do right--; while(vec.at(right).getRZCost() > pivotVal);
			do left++; while(vec.at(left).getRZCost() < pivotVal);

			if(left < right) {
				// Swap
				RZ rztmp(vec.at(left));
				vec[left] = vec.at(right);
				vec[right] = rztmp;
			} else break;
		}

		// Sort sub-vectors
		quickSort(vec, begin, right);
		quickSort(vec, right + 1, end);
	}
}

#endif
